/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import tachyon.master.ImageWriter;
import tachyon.thrift.ClientFileInfo;

public abstract class Inode
extends ImageWriter
implements Comparable<Inode> {
    private final long CREATION_TIME_MS;
    protected final boolean IS_FOLDER;
    private int mId;
    private String mName;
    private int mParentId;
    private boolean mPinned = false;

    protected Inode(String name, int id, int parentId, boolean isFolder, long creationTimeMs) {
        this.CREATION_TIME_MS = creationTimeMs;
        this.IS_FOLDER = isFolder;
        this.mId = id;
        this.mName = name;
        this.mParentId = parentId;
    }

    @Override
    public synchronized int compareTo(Inode o) {
        return this.mId - o.mId;
    }

    public synchronized boolean equals(Object o) {
        if (!(o instanceof Inode)) {
            return false;
        }
        return this.mId == ((Inode)o).mId;
    }

    public abstract ClientFileInfo generateClientFileInfo(String var1);

    public long getCreationTimeMs() {
        return this.CREATION_TIME_MS;
    }

    public synchronized int getId() {
        return this.mId;
    }

    public synchronized String getName() {
        return this.mName;
    }

    public synchronized int getParentId() {
        return this.mParentId;
    }

    public synchronized boolean isPinned() {
        return this.mPinned;
    }

    public synchronized int hashCode() {
        return this.mId;
    }

    public boolean isDirectory() {
        return this.IS_FOLDER;
    }

    public boolean isFile() {
        return !this.IS_FOLDER;
    }

    public synchronized void reverseId() {
        this.mId = -this.mId;
    }

    public synchronized void setName(String name) {
        this.mName = name;
    }

    public synchronized void setParentId(int parentId) {
        this.mParentId = parentId;
    }

    public synchronized void setPinned(boolean pinned) {
        this.mPinned = pinned;
    }

    public synchronized String toString() {
        return "Inode(" + "ID:" + this.mId + ", NAME:" + this.mName + ", PARENT_ID:" + this.mParentId + ", CREATION_TIME_MS:" + this.CREATION_TIME_MS + ", PINNED:" + this.mPinned + ")";
    }
}

