/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util.network;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import tachyon.network.ChannelType;
import tachyon.util.ThreadFactoryUtils;

public final class NettyUtils {
    private NettyUtils() {
    }

    public static EventLoopGroup createEventLoop(ChannelType type, int numThreads, String threadPrefix, boolean isDaemon) {
        ThreadFactory threadFactory = ThreadFactoryUtils.build(threadPrefix, isDaemon);
        switch (type) {
            case NIO: {
                return new NioEventLoopGroup(numThreads, threadFactory);
            }
            case EPOLL: {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
        }
        throw new IllegalArgumentException("Unknown io type: " + (Object)((Object)type));
    }

    public static Class<? extends ServerChannel> getServerChannelClass(ChannelType type) {
        switch (type) {
            case NIO: {
                return NioServerSocketChannel.class;
            }
            case EPOLL: {
                return EpollServerSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io type: " + (Object)((Object)type));
    }

    public static Class<? extends SocketChannel> getClientChannelClass(ChannelType type) {
        switch (type) {
            case NIO: {
                return NioSocketChannel.class;
            }
            case EPOLL: {
                return EpollSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io type: " + (Object)((Object)type));
    }
}

