/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import org.springframework.config.java.annotation.ResourceBundles;
import org.springframework.config.java.process.ConfigurationListenerSupport;
import org.springframework.config.java.process.ConfigurationProcessor;
import org.springframework.config.java.valuesource.MessageSourceValueSource;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceBundlesConfigurationListener
extends ConfigurationListenerSupport {
    ResourceBundlesConfigurationListener() {
    }

    @Override
    public boolean understands(Class<?> configurerClass) {
        return configurerClass.isAnnotationPresent(ResourceBundles.class);
    }

    @Override
    public void configurationClass(ConfigurationProcessor cp, String configurerBeanName, Class<?> configurerClass) {
        ResourceBundles rbs = configurerClass.getAnnotation(ResourceBundles.class);
        ReloadableResourceBundleMessageSource ms = new ReloadableResourceBundleMessageSource();
        ms.setResourceLoader(cp.getResourceLoader());
        ms.setBasenames(rbs.value());
        this.log.info((Object)("Adding resource bundles [" + StringUtils.arrayToCommaDelimitedString((Object[])rbs.value()) + "] defined in class " + configurerClass.getName()));
        cp.addValueSource(new MessageSourceValueSource((MessageSource)ms));
    }
}

