/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.annotation.DependencyCheck;
import org.springframework.config.java.annotation.Lazy;
import org.springframework.config.java.annotation.Meta;
import org.springframework.config.java.annotation.Primary;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessUtils {
    private ProcessUtils() {
    }

    static void validateBeanCreationMethod(Method beanCreationMethod) throws BeanDefinitionStoreException {
        if (Modifier.isFinal(beanCreationMethod.getModifiers())) {
            throw new BeanDefinitionStoreException("Bean creation method " + ProcessUtils.methodIdentifier(beanCreationMethod) + " may not be final");
        }
        if (Modifier.isPrivate(beanCreationMethod.getModifiers())) {
            throw new BeanDefinitionStoreException("Bean creation method " + ProcessUtils.methodIdentifier(beanCreationMethod) + " may not be private");
        }
        if (beanCreationMethod.getReturnType() == Void.TYPE) {
            throw new BeanDefinitionStoreException("Bean creation method " + ProcessUtils.methodIdentifier(beanCreationMethod) + " may not have void return");
        }
    }

    private static String methodIdentifier(Method m) {
        return m.getDeclaringClass().getName() + "." + m.getName();
    }

    static void copyAttributes(String beanName, Bean beanAnnotation, Configuration configuration, RootBeanDefinition rbd, ConfigurableListableBeanFactory beanFactory) {
        rbd.setScope(beanAnnotation.scope());
        rbd.setDependsOn(beanAnnotation.dependsOn());
        for (String alias : beanAnnotation.aliases()) {
            beanFactory.registerAlias(beanName, alias);
        }
        for (Meta meta : beanAnnotation.meta()) {
            rbd.setAttribute(meta.name(), (Object)meta.value());
        }
        if (StringUtils.hasText((String)beanAnnotation.initMethodName())) {
            rbd.setInitMethodName(beanAnnotation.initMethodName());
        }
        if (StringUtils.hasText((String)beanAnnotation.destroyMethodName())) {
            rbd.setDestroyMethodName(beanAnnotation.destroyMethodName());
        }
        if (beanAnnotation.primary() != Primary.UNSPECIFIED) {
            rbd.setPrimary(beanAnnotation.primary().booleanValue());
        }
        if (beanAnnotation.dependencyCheck() != DependencyCheck.UNSPECIFIED) {
            rbd.setDependencyCheck(beanAnnotation.dependencyCheck().value());
        } else if (configuration != null && configuration.defaultDependencyCheck() != DependencyCheck.UNSPECIFIED) {
            rbd.setDependencyCheck(configuration.defaultDependencyCheck().value());
        }
        if (beanAnnotation.lazy() != Lazy.UNSPECIFIED) {
            rbd.setLazyInit(beanAnnotation.lazy().booleanValue());
        } else if (configuration != null && configuration.defaultLazy() != Lazy.UNSPECIFIED) {
            rbd.setLazyInit(configuration.defaultLazy().booleanValue());
        }
        if (beanAnnotation.autowire() != Autowire.INHERITED) {
            rbd.setAutowireMode(beanAnnotation.autowire().value());
        } else if (configuration != null && configuration.defaultAutowire() != Autowire.INHERITED) {
            rbd.setAutowireMode(configuration.defaultAutowire().value());
        }
    }

    static Class<?> getBeanClass(String beanName, ConfigurableListableBeanFactory clbf) {
        BeanDefinition bd = clbf.getBeanDefinition(beanName);
        if (!ProcessUtils.isEligibleForConfigurationProcessing(bd) || !(bd instanceof AbstractBeanDefinition)) {
            return null;
        }
        AbstractBeanDefinition definition = (AbstractBeanDefinition)bd;
        if (definition.hasBeanClass()) {
            return definition.getBeanClass();
        }
        if (bd.getBeanClassName() != null) {
            try {
                return ClassUtils.forName((String)bd.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Bean class '" + bd.getBeanClassName() + "' not found");
            }
        }
        return null;
    }

    private static boolean isEligibleForConfigurationProcessing(BeanDefinition def) {
        return !def.isAbstract() && StringUtils.hasText((String)def.getBeanClassName());
    }
}

