/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;
import org.codehaus.gmaven.adapter.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicResourceLoader
implements ResourceLoader {
    protected static final String DOT_GROOVY = ".groovy";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ClassLoader classLoader;

    public BasicResourceLoader(ClassLoader classLoader) {
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
    }

    @Nullable
    public URL loadResource(String name) throws MalformedURLException {
        return this.resolve(name, this.classLoader);
    }

    @Nullable
    protected URL resolve(String className, ClassLoader classLoader) throws MalformedURLException {
        this.log.trace("Resolve; class-name: {}, class-loader: {}", (Object)className, (Object)classLoader);
        String name = this.resourceName(className);
        this.log.trace("Resolve; resource: {}", (Object)name);
        boolean tcl = false;
        URL resource = classLoader.getResource(name);
        if (resource == null) {
            resource = Thread.currentThread().getContextClassLoader().getResource(name);
            tcl = true;
        }
        this.log.trace("Resource: {}, tcl: {}", (Object)resource, (Object)tcl);
        return resource;
    }

    protected String resourceName(String className) {
        String name = className;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!name.endsWith(DOT_GROOVY)) {
            name = name.replace('.', '/');
            name = name + DOT_GROOVY;
        }
        return name;
    }
}

