/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.components.config.annotations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.spring.ProcessEngineFactoryBean;
import org.activiti.spring.SpringJobExecutor;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.activiti.spring.annotations.ActivitiConfigurer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class ActivitiConfiguration {
    @Autowired(required=false)
    private List<TaskExecutor> executors;
    @Autowired(required=false)
    private List<ActivitiConfigurer> activitiConfigurers;
    @Autowired(required=false)
    private Map<String, DataSource> dataSources;
    @Autowired(required=false)
    private List<PlatformTransactionManager> platformTransactionManagers;
    @Autowired(required=false)
    private List<SpringJobExecutor> springJobExecutors;

    @Bean
    public SpringProcessEngineConfiguration springProcessEngineConfiguration() {
        ActivitiConfigurer configurer = this.activitiConfigurer(this.activitiConfigurers);
        ArrayList<Resource> processDefinitionResources = new ArrayList<Resource>();
        configurer.processDefinitionResources(processDefinitionResources);
        SpringProcessEngineConfiguration engine = new SpringProcessEngineConfiguration();
        if (!processDefinitionResources.isEmpty()) {
            engine.setDeploymentResources(processDefinitionResources.toArray(new Resource[processDefinitionResources.size()]));
        }
        DataSource dataSource = this.dataSource(configurer, this.dataSources);
        engine.setDataSource(dataSource);
        engine.setTransactionManager(this.platformTransactionManager(dataSource));
        engine.setJobExecutor(this.springJobExecutor());
        engine.setDatabaseSchemaUpdate("true");
        configurer.postProcessSpringProcessEngineConfiguration(engine);
        return engine;
    }

    @Bean
    public ProcessEngineFactoryBean processEngine(SpringProcessEngineConfiguration springProcessEngineConfiguration) {
        ProcessEngineFactoryBean processEngineFactoryBean = new ProcessEngineFactoryBean();
        processEngineFactoryBean.setProcessEngineConfiguration(springProcessEngineConfiguration);
        return processEngineFactoryBean;
    }

    @Bean
    public RuntimeService runtimeService(ProcessEngine processEngine) {
        return processEngine.getRuntimeService();
    }

    @Bean
    public RepositoryService repositoryService(ProcessEngine processEngine) {
        return processEngine.getRepositoryService();
    }

    @Bean
    public TaskService taskService(ProcessEngine processEngine) {
        return processEngine.getTaskService();
    }

    @Bean
    public HistoryService historyService(ProcessEngine processEngine) {
        return processEngine.getHistoryService();
    }

    @Bean
    public ManagementService managementService(ProcessEngine processEngine) {
        return processEngine.getManagementService();
    }

    @Bean
    public FormService formService(ProcessEngine processEngine) {
        return processEngine.getFormService();
    }

    @Bean
    public IdentityService identityService(ProcessEngine processEngine) {
        return processEngine.getIdentityService();
    }

    protected PlatformTransactionManager platformTransactionManager(final DataSource dataSource) {
        return ActivitiConfiguration.first(this.platformTransactionManagers, new ObjectFactory<PlatformTransactionManager>(){

            public PlatformTransactionManager getObject() throws BeansException {
                return new DataSourceTransactionManager(dataSource);
            }
        });
    }

    protected SpringJobExecutor springJobExecutor() {
        return ActivitiConfiguration.first(this.springJobExecutors, new ObjectFactory<SpringJobExecutor>(){

            public SpringJobExecutor getObject() throws BeansException {
                TaskExecutor taskExecutor = (TaskExecutor)ActivitiConfiguration.first(ActivitiConfiguration.this.executors, (ObjectFactory)new ObjectFactory<TaskExecutor>(){

                    public TaskExecutor getObject() throws BeansException {
                        return new SyncTaskExecutor();
                    }
                });
                return new SpringJobExecutor(taskExecutor);
            }
        });
    }

    protected ActivitiConfigurer activitiConfigurer(final List<ActivitiConfigurer> activitiConfigurers) {
        return new ActivitiConfigurer(){

            @Override
            public void processDefinitionResources(List<Resource> resourceList) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                ClassPathResource defaultClassPathResourceMatcher = new ClassPathResource("classpath:/processes/**bpmn20.xml");
                if (defaultClassPathResourceMatcher.exists()) {
                    resources.add((Resource)defaultClassPathResourceMatcher);
                }
                if (activitiConfigurers != null && !activitiConfigurers.isEmpty()) {
                    for (ActivitiConfigurer ac : activitiConfigurers) {
                        ac.processDefinitionResources(resources);
                    }
                }
                resourceList.addAll(resources);
            }

            @Override
            public void postProcessSpringProcessEngineConfiguration(SpringProcessEngineConfiguration springProcessEngineConfiguration) {
                if (activitiConfigurers != null) {
                    for (ActivitiConfigurer configurer : activitiConfigurers) {
                        configurer.postProcessSpringProcessEngineConfiguration(springProcessEngineConfiguration);
                    }
                }
            }

            @Override
            public DataSource dataSource() {
                return null;
            }
        };
    }

    private DataSource dataSource(ActivitiConfigurer activitiConfigurer, Map<String, DataSource> dataSourceMap) {
        DataSource dataSource;
        DataSource ds = null;
        if (activitiConfigurer != null && null != (dataSource = activitiConfigurer.dataSource())) {
            ds = dataSource;
        }
        if (dataSourceMap != null) {
            String defaultName;
            if (!dataSourceMap.isEmpty()) {
                Iterator<DataSource> i$ = dataSourceMap.values().iterator();
                while (i$.hasNext()) {
                    DataSource d;
                    ds = d = i$.next();
                }
            }
            if (dataSourceMap.containsKey(defaultName = "activitiDataSource")) {
                ds = dataSourceMap.get(defaultName);
            }
        }
        if (ds == null) {
            try {
                SimpleDriverDataSource simpleDriverDataSource = new SimpleDriverDataSource();
                simpleDriverDataSource.setDriverClass(Class.forName("org.h2.Driver"));
                simpleDriverDataSource.setUrl("jdbc:h2:mem:activiti;DB_CLOSE_DELAY=1000");
                simpleDriverDataSource.setUsername("sa");
                simpleDriverDataSource.setPassword("");
                ds = simpleDriverDataSource;
            }
            catch (ClassNotFoundException e) {
                throw new ActivitiException("No dataSource bean was found. Tried to create default H2 in memory database, but couldn't find the driver on the classpath");
            }
        }
        return ds;
    }

    private static <T> T first(List<T> tList, ObjectFactory<T> tObjectFactory) {
        Object rt = tList != null && !tList.isEmpty() ? tList.iterator().next() : tObjectFactory.getObject();
        return (T)rt;
    }
}

