/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.definition;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.activiti.workflow.simple.definition.AbstractStepListContainer;
import org.activiti.workflow.simple.definition.ListStepDefinition;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.definition.WorkflowDefinition;
import org.activiti.workflow.simple.exception.SimpleWorkflowException;

@JsonTypeName(value="parallel-step")
public class ParallelStepsDefinition
extends AbstractStepListContainer<ParallelStepsDefinition>
implements StepDefinition {
    private static final long serialVersionUID = 1L;
    protected WorkflowDefinition workflowDefinition;
    protected Map<String, Object> parameters = new HashMap<String, Object>();

    public ParallelStepsDefinition() {
    }

    public ParallelStepsDefinition(WorkflowDefinition workflowDefinition) {
        this.workflowDefinition = workflowDefinition;
    }

    public WorkflowDefinition endParallel() {
        if (this.workflowDefinition == null) {
            throw new SimpleWorkflowException("Can only call endParallel when inParallel was called on a workflow definition first");
        }
        return this.workflowDefinition;
    }

    @Override
    public StepDefinition clone() {
        ParallelStepsDefinition clone = new ParallelStepsDefinition();
        clone.setValues(this);
        return clone;
    }

    @Override
    public void setValues(StepDefinition otherDefinition) {
        if (!(otherDefinition instanceof ParallelStepsDefinition)) {
            throw new SimpleWorkflowException("An instance of ParallelStepsDefinition is required to set values");
        }
        ParallelStepsDefinition definition = (ParallelStepsDefinition)otherDefinition;
        this.setId(definition.getId());
        this.setParameters(new HashMap<String, Object>(otherDefinition.getParameters()));
        this.steps = new ArrayList();
        if (definition.getStepList() != null && definition.getStepList().size() > 0) {
            for (ListStepDefinition stepDefinition : definition.getStepList()) {
                this.steps.add(stepDefinition.clone());
            }
        }
    }

    @Override
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }
}

