/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.definition;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.activiti.workflow.simple.definition.AbstractStepDefinitionContainer;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.definition.StepListContainer;
import org.activiti.workflow.simple.exception.SimpleWorkflowException;

@JsonTypeName(value="list")
public class ListStepDefinition<T>
extends AbstractStepDefinitionContainer<ListStepDefinition<T>>
implements StepDefinition {
    private static final long serialVersionUID = 1L;
    protected StepListContainer<T> stepListContainer;
    protected String name;
    protected Map<String, Object> parameters = new HashMap<String, Object>();

    public ListStepDefinition() {
    }

    public ListStepDefinition(StepListContainer<T> stepListContainer) {
        this.stepListContainer = stepListContainer;
    }

    public T endList() {
        if (this.stepListContainer == null) {
            throw new SimpleWorkflowException("Can only call endList when inList was called on a workflow definition first");
        }
        return (T)this.stepListContainer;
    }

    @Override
    public ListStepDefinition<T> clone() {
        ListStepDefinition<T> clone = new ListStepDefinition<T>();
        clone.setValues(this);
        return clone;
    }

    @Override
    public void setValues(StepDefinition otherDefinition) {
        if (!(otherDefinition instanceof ListStepDefinition)) {
            throw new SimpleWorkflowException("An instance of SerialStepsDefinition is required to set values");
        }
        ListStepDefinition definition = (ListStepDefinition)otherDefinition;
        this.setId(definition.getId());
        this.setName(definition.getName());
        this.setParameters(new HashMap<String, Object>(otherDefinition.getParameters()));
        this.steps = new ArrayList();
        if (definition.getSteps() != null && definition.getSteps().size() > 0) {
            for (StepDefinition stepDefinition : definition.getSteps()) {
                this.steps.add(stepDefinition.clone());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }
}

