/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.definition;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.activiti.workflow.simple.definition.AbstractConditionStepListContainer;
import org.activiti.workflow.simple.definition.ListConditionStepDefinition;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.definition.WorkflowDefinition;
import org.activiti.workflow.simple.exception.SimpleWorkflowException;

@JsonTypeName(value="choice-step")
public class ChoiceStepsDefinition
extends AbstractConditionStepListContainer<ChoiceStepsDefinition>
implements StepDefinition {
    private static final long serialVersionUID = 1L;
    protected WorkflowDefinition workflowDefinition;
    protected Map<String, Object> parameters = new HashMap<String, Object>();

    public ChoiceStepsDefinition() {
    }

    public ChoiceStepsDefinition(WorkflowDefinition workflowDefinition) {
        this.workflowDefinition = workflowDefinition;
    }

    public WorkflowDefinition endChoice() {
        if (this.workflowDefinition == null) {
            throw new SimpleWorkflowException("Can only call endChoice when inChoice was called on a workflow definition first");
        }
        return this.workflowDefinition;
    }

    @Override
    public StepDefinition clone() {
        ChoiceStepsDefinition clone = new ChoiceStepsDefinition();
        clone.setValues(this);
        return clone;
    }

    @Override
    public void setValues(StepDefinition otherDefinition) {
        if (!(otherDefinition instanceof ChoiceStepsDefinition)) {
            throw new SimpleWorkflowException("An instance of ParallelStepsDefinition is required to set values");
        }
        ChoiceStepsDefinition definition = (ChoiceStepsDefinition)otherDefinition;
        this.setId(definition.getId());
        this.setParameters(new HashMap<String, Object>(otherDefinition.getParameters()));
        this.steps = new ArrayList();
        if (definition.getStepList() != null && definition.getStepList().size() > 0) {
            for (ListConditionStepDefinition stepDefinition : definition.getStepList()) {
                this.steps.add(stepDefinition.clone());
            }
        }
    }

    @Override
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }
}

