/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.api.io;

import com.qiniu.api.config.Config;
import com.qiniu.api.io.PutExtra;
import com.qiniu.api.io.PutRet;
import com.qiniu.api.net.CallRet;
import com.qiniu.api.net.Client;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;

public class IoApi {
    public static final String UNDEFINED_KEY = null;
    public static final int NO_CRC32 = 0;
    public static final int AUTO_CRC32 = 1;
    public static final int WITH_CRC32 = 2;

    private static PutRet put(String uptoken, String key, File file, PutExtra extra) {
        if (!file.exists() || !file.canRead()) {
            return new PutRet(new CallRet(0, new Exception("File does not exist or not readable.")));
        }
        extra = extra == null ? new PutExtra() : extra;
        MultipartEntity requestEntity = new MultipartEntity();
        try {
            requestEntity.addPart("token", (ContentBody)new StringBody(uptoken));
            FileBody fileBody = IoApi.buildFileBody(file, extra);
            requestEntity.addPart("file", (ContentBody)fileBody);
            IoApi.setKey(requestEntity, key);
            IoApi.setParam(requestEntity, extra.params);
            if (extra.checkCrc != 0) {
                if (extra.crc32 == 0L) {
                    return new PutRet(new CallRet(0, new Exception("no crc32 specified!")));
                }
                requestEntity.addPart("crc32", (ContentBody)new StringBody(extra.crc32 + ""));
            }
            if (extra.params != null) {
                for (Map.Entry<String, String> xvar : extra.params.entrySet()) {
                    requestEntity.addPart(xvar.getKey(), (ContentBody)new StringBody(xvar.getValue(), Charset.forName("utf-8")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new PutRet(new CallRet(0, e));
        }
        String url = Config.UP_HOST;
        CallRet ret = new Client().callWithMultiPart(url, requestEntity);
        return new PutRet(ret);
    }

    private static FileBody buildFileBody(File file, PutExtra extra) {
        if (extra.mimeType != null) {
            return new FileBody(file, extra.mimeType);
        }
        return new FileBody(file);
    }

    private static void setKey(MultipartEntity requestEntity, String key) throws UnsupportedEncodingException {
        if (key != null) {
            requestEntity.addPart("key", (ContentBody)new StringBody(key, Charset.forName("utf-8")));
        }
    }

    private static void setParam(MultipartEntity requestEntity, Map<String, String> params) throws UnsupportedEncodingException {
        if (params == null) {
            return;
        }
        for (String name : params.keySet()) {
            requestEntity.addPart(name, (ContentBody)new StringBody(params.get(name), Charset.forName("utf-8")));
        }
    }

    private static PutRet putStream(String uptoken, String key, InputStream reader, PutExtra extra, long length) {
        extra = extra == null ? new PutExtra() : extra;
        MultipartEntity requestEntity = new MultipartEntity();
        try {
            requestEntity.addPart("token", (ContentBody)new StringBody(uptoken));
            String fileName = key != null ? key : "null";
            AbstractContentBody inputBody = IoApi.buildInputStreamBody(reader, extra, fileName, length);
            requestEntity.addPart("file", (ContentBody)inputBody);
            IoApi.setKey(requestEntity, key);
            IoApi.setParam(requestEntity, extra.params);
            if (extra.checkCrc != 0) {
                if (extra.crc32 == 0L) {
                    return new PutRet(new CallRet(0, new Exception("no crc32 specified!")));
                }
                requestEntity.addPart("crc32", (ContentBody)new StringBody(extra.crc32 + ""));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new PutRet(new CallRet(0, e));
        }
        String url = Config.UP_HOST;
        CallRet ret = new Client().callWithMultiPart(url, requestEntity);
        return new PutRet(ret);
    }

    private static AbstractContentBody buildInputStreamBody(InputStream reader, PutExtra extra, String fileName, final long length) {
        if (extra.mimeType != null) {
            return new InputStreamBody(reader, extra.mimeType, fileName){

                public long getContentLength() {
                    return length;
                }
            };
        }
        return new InputStreamBody(reader, fileName){

            public long getContentLength() {
                return length;
            }
        };
    }

    private static PutRet putStream0(String uptoken, String key, InputStream reader, PutExtra extra, long length) {
        long l = length = length <= 0L ? IoApi.getLength(reader) : length;
        if (length != -1L) {
            return IoApi.putStream(uptoken, key, reader, extra, length);
        }
        return IoApi.toPutFile(uptoken, key, reader, extra);
    }

    private static long getLength(InputStream is) {
        try {
            return is.available();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PutRet toPutFile(String uptoken, String key, InputStream reader, PutExtra extra) {
        File file = null;
        try {
            file = IoApi.copyToTmpFile(reader);
            PutRet putRet = IoApi.put(uptoken, key, file, extra);
            return putRet;
        }
        finally {
            if (file != null) {
                try {
                    file.delete();
                }
                catch (Exception e) {}
            }
        }
    }

    private static File copyToTmpFile(InputStream from) {
        FileOutputStream os = null;
        try {
            int l;
            File to = File.createTempFile("qiniu_", ".tmp");
            os = new FileOutputStream(to);
            byte[] b = new byte[65536];
            while ((l = from.read(b)) != -1) {
                os.write(b, 0, l);
            }
            os.flush();
            File file = to;
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException("create tmp file failed.", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {}
            }
            if (from != null) {
                try {
                    from.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static PutRet Put(String uptoken, String key, InputStream reader, PutExtra extra, long length) {
        return IoApi.putStream0(uptoken, key, reader, extra, length);
    }

    public static PutRet Put(String uptoken, String key, InputStream reader, PutExtra extra) {
        return IoApi.Put(uptoken, key, reader, extra, -1L);
    }

    public static PutRet putFile(String uptoken, String key, String fileName, PutExtra extra) {
        File file = new File(fileName);
        return IoApi.putFile(uptoken, key, file, extra);
    }

    public static PutRet putFile(String uptoken, String key, File file, PutExtra extra) {
        if (extra.checkCrc == 1) {
            try {
                extra.crc32 = IoApi.getCRC32(file);
            }
            catch (Exception e) {
                return new PutRet(new CallRet(0, e));
            }
        }
        return IoApi.put(uptoken, key, file, extra);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getCRC32(File file) throws Exception {
        CRC32 crc32 = new CRC32();
        FileInputStream in = null;
        FilterInputStream checkedInputStream = null;
        long crc = 0L;
        try {
            in = new FileInputStream(file);
            checkedInputStream = new CheckedInputStream(in, crc32);
            while (((CheckedInputStream)checkedInputStream).read() != -1) {
            }
            crc = crc32.getValue();
        }
        finally {
            if (in != null) {
                in.close();
                in = null;
            }
            if (checkedInputStream != null) {
                checkedInputStream.close();
                checkedInputStream = null;
            }
        }
        return crc;
    }
}

