/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.util;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ResourceUtils {
    static Map<String, String> cache = new HashMap<String, String>();
    static List<Properties> properties = new ArrayList<Properties>();
    static boolean inited;

    private static synchronized void load() {
        try {
            File[] propFiles;
            if (!properties.isEmpty()) {
                return;
            }
            File dir = new File(Thread.currentThread().getContextClassLoader().getResource("").getPath());
            for (File file : propFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("properties");
                }
            })) {
                Properties p = new Properties();
                p.load(new FileReader(file));
                properties.add(p);
            }
            inited = true;
        }
        catch (Exception e) {
            inited = true;
            throw new RuntimeException(e);
        }
    }

    public static String get(String key, String ... defaults) {
        if (!inited) {
            ResourceUtils.load();
        }
        if (cache.containsKey(key)) {
            return cache.get(key);
        }
        String value = null;
        for (Properties prop : properties) {
            value = prop.getProperty(key);
            if (value == null) continue;
            cache.put(key, value);
            return value;
        }
        if (defaults != null && defaults.length > 0) {
            return defaults[0];
        }
        return System.getProperty(key);
    }
}

