/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateConvertDeserializer
extends JsonDeserializer<Date> {
    private static final String pattern = "yyyy-MM-dd";

    public Date deserialize(JsonParser jsonParser, DeserializationContext dc) throws JsonProcessingException {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            String val = jsonParser.getText();
            date = dateFormat.parse(val);
        }
        catch (IOException | ParseException pex) {
            throw new RuntimeException("json\u8f6c\u6362Date\u5f02\u5e38\uff0c\u683c\u5f0f\uff1ayyyy-MM-dd");
        }
        return date;
    }
}

