/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.common.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.JSONPObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JsonMapper {
    private static JsonMapper defaultMapper;
    private ObjectMapper mapper = new ObjectMapper();

    public JsonMapper() {
        this(null);
    }

    public JsonMapper(JsonInclude.Include include) {
        if (include != null) {
            this.mapper.setSerializationInclusion(include);
        }
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, false);
    }

    public JsonMapper enumAndStringConvert(boolean enabled) {
        if (enabled) {
            this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
            this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        } else {
            this.mapper.disable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
            this.mapper.disable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        }
        return this;
    }

    public JsonMapper dateAndTimestampConvert(boolean enabled) {
        if (enabled) {
            this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
            this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        } else {
            this.mapper.disable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
            this.mapper.disable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        }
        return this;
    }

    public static JsonMapper nonEmptyMapper() {
        return new JsonMapper(JsonInclude.Include.NON_EMPTY);
    }

    public static JsonMapper nonNullMapper() {
        return new JsonMapper(JsonInclude.Include.NON_NULL);
    }

    public static JsonMapper nonDefaultMapper() {
        return new JsonMapper(JsonInclude.Include.NON_DEFAULT);
    }

    public String toJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T toObject(String jsonString, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> toList(String jsonString, Class<T> elementType) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        JavaType javaType = this.mapper.getTypeFactory().constructParametrizedType(ArrayList.class, ArrayList.class, new Class[]{elementType});
        return (List)this.toObject(jsonString, javaType);
    }

    public <T> T toObject(String jsonString, JavaType javaType) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T update(String jsonString, T object) {
        try {
            return (T)this.mapper.readerForUpdating(object).readValue(jsonString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toJsonP(String functionName, Object object) {
        return this.toJson(new JSONPObject(functionName, object));
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public static JsonMapper getDefault() {
        if (defaultMapper == null) {
            defaultMapper = new JsonMapper();
            defaultMapper.dateAndTimestampConvert(false);
        }
        return defaultMapper;
    }
}

