/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.util.Collections;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.IteratorStatus;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.exception.BeetlParserException;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.IGoto;
import org.beetl.core.statement.IVarIndex;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.Type;
import org.beetl.core.statement.VarDefineNode;

public final class ForStatement
extends Statement
implements IGoto {
    public Expression idNode;
    public Expression exp;
    public Statement forPart;
    public Statement elseforPart;
    public boolean hasGoto = false;
    public short itType = 0;
    public boolean hasSafe;

    public ForStatement(VarDefineNode idNode, Expression exp, boolean hasSafe, Statement forPart, Statement elseforPart, GrammarToken token) {
        super(token);
        this.idNode = idNode;
        this.exp = exp;
        this.hasSafe = hasSafe;
        this.elseforPart = elseforPart;
        this.forPart = forPart;
    }

    @Override
    public final void execute(Context ctx) {
        int varIndex = ((IVarIndex)((Object)this.idNode)).getVarIndex();
        Object collection = this.exp.evaluate(ctx);
        IteratorStatus it = null;
        if (collection == null) {
            if (!this.hasSafe) {
                BeetlException ex = new BeetlException("NULL");
                ex.pushToken(this.exp.token);
                throw ex;
            }
            it = new IteratorStatus(Collections.EMPTY_LIST);
        } else {
            it = IteratorStatus.getIteratorStatusByType(collection, this.itType);
            if (it == null) {
                BeetlParserException ex = new BeetlParserException("COLLECTION_EXPECTED_ERROR");
                ex.pushToken(this.exp.token);
                throw ex;
            }
        }
        ctx.vars[varIndex + 1] = it;
        if (this.hasGoto) {
            while (it.hasNext()) {
                ctx.vars[varIndex] = it.next();
                this.forPart.execute(ctx);
                switch (ctx.gotoFlag) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ctx.gotoFlag = 0;
                        break;
                    }
                    case 3: {
                        return;
                    }
                    case 2: {
                        ctx.gotoFlag = 0;
                        return;
                    }
                }
            }
            if (!it.hasData() && this.elseforPart != null) {
                this.elseforPart.execute(ctx);
            }
            return;
        }
        while (it.hasNext()) {
            ctx.vars[varIndex] = it.next();
            this.forPart.execute(ctx);
        }
        if (!it.hasData() && this.elseforPart != null) {
            this.elseforPart.execute(ctx);
        }
    }

    @Override
    public final boolean hasGoto() {
        return this.hasGoto;
    }

    @Override
    public final void setGoto(boolean occour) {
        this.hasGoto = occour;
    }

    @Override
    public void infer(InferContext inferCtx) {
        this.exp.infer(inferCtx);
        this.idNode.type = this.exp.getType().types != null ? (Map.class.isAssignableFrom(this.exp.getType().cls) ? Type.mapEntryType : this.exp.getType().types[0]) : Type.ObjectType;
        int index = ((IVarIndex)((Object)this.idNode)).getVarIndex();
        inferCtx.types[index] = this.idNode.type;
        inferCtx.types[index + 1] = new Type(IteratorStatus.class, this.idNode.type.cls);
        this.forPart.infer(inferCtx);
        if (this.elseforPart != null) {
            this.elseforPart.infer(inferCtx);
        }
    }
}

