/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.lab;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.beetl.core.Configuration;
import org.beetl.core.Context;
import org.beetl.core.Function;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;
import org.beetl.core.lab.ColumnTag;
import org.beetl.core.lab.Page;
import org.beetl.core.lab.TestUser;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.statement.PlaceholderST;

public class Test {
    public static void main(String[] args) throws Exception {
        ClasspathResourceLoader resourceLoader = new ClasspathResourceLoader();
        Configuration cfg = Configuration.defaultConfiguration();
        cfg.setDirectByteOutput(true);
        cfg.getResourceMap().put("RESOURCE.autoCheck", "true");
        GroupTemplate gt = new GroupTemplate(resourceLoader, cfg);
        cfg.setStatementStart("<%");
        cfg.setStatementEnd("%>");
        gt.registerFunction("test", new TestFun());
        gt.registerTag("col", ColumnTag.class);
        PlaceholderST.output = new PlaceholderST.Output(){

            @Override
            public void write(Context ctx, Object value) throws IOException {
                ctx.byteWriter.writeString("ok" + value.toString());
            }
        };
        Page page = new Page();
        page.data.add(new TestUser("joeli"));
        for (int i = 0; i < 1; ++i) {
            Template t = gt.getTemplate("/org/beetl/core/lab/hello.txt");
            t.binding("$page", new HashMap());
            t.binding("user", new TestUser(""));
            t.binding("info", TestUser.getInfo());
            t.binding("n", new BigDecimal("0.0000"));
            t.binding("bo", "a");
            t.binding("page", page);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            try {
                t.renderTo(bs);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println(new String(bs.toByteArray()));
        }
    }

    public static void testOne() {
    }

    public static class TestFun
    implements Function {
        public String[] call(Object[] paras, Context ctx) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("hi");
            list.add("joel");
            System.out.println("list -----");
            return list.toArray(new String[0]);
        }
    }
}

