/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.token;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TokenCreator;

public class WeixinProviderTokenCreator
extends TokenCreator {
    private final String corpid;
    private final String providersecret;

    public WeixinProviderTokenCreator(String corpid, String providersecret) {
        this.corpid = corpid;
        this.providersecret = providersecret;
    }

    public String key0() {
        return String.format("qy_provider_token_%s", this.corpid);
    }

    public Token create() throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("corpid", (Object)this.corpid);
        obj.put("provider_secret", (Object)this.providersecret);
        WeixinResponse response = this.weixinExecutor.post("https://qyapi.weixin.qq.com/cgi-bin/service/get_provider_token", obj.toJSONString());
        obj = response.getAsJson();
        return new Token(obj.getString("provider_access_token"), obj.getLongValue("expires_in") * 1000L);
    }
}

