/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.suite;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.PerTicketManager;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;

public class WeixinTokenSuiteCreator
extends TokenCreator {
    private final PerTicketManager perTicketManager;
    private final TokenManager suiteTokenManager;

    public WeixinTokenSuiteCreator(PerTicketManager perTicketManager, TokenManager suiteTokenManager) {
        this.perTicketManager = perTicketManager;
        this.suiteTokenManager = suiteTokenManager;
    }

    public String key0() {
        return String.format("qy_token_suite_%s_%s", this.perTicketManager.getThirdId(), this.perTicketManager.getAuthAppId());
    }

    public Token create() throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("suite_id", (Object)this.perTicketManager.getThirdId());
        obj.put("auth_corpid", (Object)this.perTicketManager.getAuthAppId());
        obj.put("permanent_code", (Object)this.perTicketManager.getAccessTicket());
        WeixinResponse response = this.weixinExecutor.post(String.format("https://qyapi.weixin.qq.com/cgi-bin/service/get_corp_token?suite_access_token=%s", this.suiteTokenManager.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        return new Token(obj.getString("access_token"), obj.getLongValue("expires_in") * 1000L);
    }
}

