/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.suite;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TicketManager;
import com.foxinmy.weixin4j.token.TokenCreator;

public class WeixinSuiteTokenCreator
extends TokenCreator {
    private final TicketManager ticketManager;

    public WeixinSuiteTokenCreator(TicketManager ticketManager) {
        this.ticketManager = ticketManager;
    }

    public String key0() {
        return String.format("qy_suite_token_%s", this.ticketManager.getThirdId());
    }

    public Token create() throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("suite_id", (Object)this.ticketManager.getThirdId());
        obj.put("suite_secret", (Object)this.ticketManager.getThirdSecret());
        obj.put("suite_ticket", (Object)this.ticketManager.getAccessTicket());
        WeixinResponse response = this.weixinExecutor.post("https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token", obj.toJSONString());
        obj = response.getAsJson();
        return new Token(obj.getString("suite_access_token"), obj.getLongValue("expires_in") * 1000L);
    }
}

