/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.api.MediaApi;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.qy.model.OUserInfo;
import com.foxinmy.weixin4j.qy.model.User;
import com.foxinmy.weixin4j.qy.type.InviteType;
import com.foxinmy.weixin4j.qy.type.UserStatus;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.util.NameValue;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class UserApi
extends QyApi {
    private final MediaApi mediaApi;
    private final TokenManager tokenManager;

    public UserApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
        this.mediaApi = new MediaApi(tokenManager);
    }

    public ApiResult createUser(User user) throws WeixinException {
        String user_create_uri = this.getRequestUri("user_create_uri");
        return this.excute(user_create_uri, user, null);
    }

    public ApiResult createUser(User user, InputStream avatar) throws WeixinException {
        String user_create_uri = this.getRequestUri("user_create_uri");
        return this.excute(user_create_uri, user, avatar);
    }

    public ApiResult updateUser(User user) throws WeixinException {
        String user_update_uri = this.getRequestUri("user_update_uri");
        return this.excute(user_update_uri, user, null);
    }

    public ApiResult updateUser(User user, InputStream avatar) throws WeixinException {
        String user_update_uri = this.getRequestUri("user_update_uri");
        return this.excute(user_update_uri, user, avatar);
    }

    private ApiResult excute(String uri, User user, InputStream avatar) throws WeixinException {
        JSONObject obj = (JSONObject)JSON.toJSON((Object)user);
        Object val = obj.remove((Object)"extattr");
        if (val != null) {
            JSONObject attrs = new JSONObject();
            attrs.put("attrs", val);
            obj.put("extattr", (Object)attrs);
        }
        if ((val = obj.remove((Object)"status")) != null) {
            obj.put("enable", val);
        }
        if (avatar != null) {
            obj.put("avatar_mediaid", (Object)this.mediaApi.uploadMedia(0, avatar, null));
        } else {
            obj.put("avatar_mediaid", obj.remove((Object)"avatar"));
        }
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public User getUser(String userid) throws WeixinException {
        String user_get_uri = this.getRequestUri("user_get_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(user_get_uri, token.getAccessToken(), userid), new URLParameter[0]);
        JSONObject obj = response.getAsJson();
        Object attrs = obj.remove((Object)"extattr");
        User user = (User)JSON.toJavaObject((JSON)obj, User.class);
        if (attrs != null) {
            user.setExtattr(JSON.parseArray((String)((JSONObject)attrs).getString("attrs"), NameValue.class));
        }
        return user;
    }

    public User getUserByCode(String code) throws WeixinException {
        String[] userIds = this.getUserIdByCode(code);
        if (Boolean.parseBoolean(userIds[2])) {
            return this.getUser(this.openid2userid(userIds[0]));
        }
        return this.getUser(userIds[0]);
    }

    public String[] getUserIdByCode(String code) throws WeixinException {
        String user_getid_uri = this.getRequestUri("user_getid_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(user_getid_uri, token.getAccessToken(), code), new URLParameter[0]);
        JSONObject result = response.getAsJson();
        String userId = result.getString("UserId");
        boolean need2 = false;
        if (StringUtil.isBlank((CharSequence)userId)) {
            userId = result.getString("OpenId");
            need2 = true;
        }
        return new String[]{userId, result.getString("DeviceId"), Boolean.toString(need2)};
    }

    public OUserInfo getOUserInfoByCode(String providerToken, String authCode) throws WeixinException {
        String oauth_logininfo_uri = this.getRequestUri("oauth_logininfo_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(oauth_logininfo_uri, providerToken), String.format("{\"auth_code\":\"%s\"}", authCode));
        return (OUserInfo)JSON.parseObject((String)response.getAsString(), OUserInfo.class);
    }

    public List<User> listUser(int partyId, boolean fetchChild, UserStatus userStatus, boolean findDetail) throws WeixinException {
        String user_list_uri = findDetail ? this.getRequestUri("user_list_uri") : this.getRequestUri("user_slist_uri");
        Token token = (Token)this.tokenManager.getCache();
        if (userStatus == null) {
            userStatus = UserStatus.UNFOLLOW;
        }
        WeixinResponse response = this.weixinExecutor.get(String.format(user_list_uri, token.getAccessToken(), partyId, fetchChild ? 1 : 0, userStatus.getVal()), new URLParameter[0]);
        ArrayList<User> list = null;
        if (findDetail) {
            JSONArray arrays = response.getAsJson().getJSONArray("userlist");
            list = new ArrayList<User>(arrays.size());
            for (int i = 0; i < arrays.size(); ++i) {
                JSONObject obj = arrays.getJSONObject(i);
                Object attrs = obj.remove((Object)"extattr");
                User user = (User)JSON.toJavaObject((JSON)obj, User.class);
                if (attrs != null) {
                    user.setExtattr(JSON.parseArray((String)((JSONObject)attrs).getString("attrs"), NameValue.class));
                }
                list.add(user);
            }
        } else {
            list = JSON.parseArray((String)response.getAsJson().getString("userlist"), User.class);
        }
        return list;
    }

    public List<User> listUser(int partyId) throws WeixinException {
        return this.listUser(partyId, false, UserStatus.BOTH, false);
    }

    public ApiResult deleteUser(String userid) throws WeixinException {
        String user_delete_uri = this.getRequestUri("user_delete_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(user_delete_uri, token.getAccessToken(), userid), new URLParameter[0]);
        return response.getAsResult();
    }

    public ApiResult batchDeleteUser(List<String> userIds) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("useridlist", userIds);
        String user_delete_uri = this.getRequestUri("user_batchdelete_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(user_delete_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult authsucc(String userId) throws WeixinException {
        String user_authsucc_uri = this.getRequestUri("user_authsucc_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(user_authsucc_uri, token.getAccessToken(), userId), new URLParameter[0]);
        return response.getAsResult();
    }

    public InviteType inviteUser(String userId, String tips) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("userid", (Object)userId);
        obj.put("invite_tips", (Object)tips);
        String invite_user_uri = this.getRequestUri("invite_user_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(invite_user_uri, token.getAccessToken()), obj.toJSONString());
        int type = response.getAsJson().getIntValue("type");
        if (type == 1) {
            return InviteType.WEIXIN;
        }
        if (type == 2) {
            return InviteType.EMAIL;
        }
        return null;
    }

    public String[] userid2openid(String userid, int agentid) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("userid", (Object)userid);
        if (agentid > 0) {
            obj.put("agentid", (Object)agentid);
        }
        String userid2openid_uri = this.getRequestUri("userid2openid_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(userid2openid_uri, this.tokenManager.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        return new String[]{obj.getString("openid"), obj.getString("appid")};
    }

    public String openid2userid(String openid) throws WeixinException {
        String openid2userid_uri = this.getRequestUri("openid2userid_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(openid2userid_uri, this.tokenManager.getAccessToken()), String.format("{\"openid\": \"%s\"}", openid));
        return response.getAsJson().getString("userid");
    }
}

