/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.foxinmy.weixin4j.cache.Cacheable;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.api.AgentApi;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.qy.model.AgentInfo;
import com.foxinmy.weixin4j.qy.model.AgentSetter;
import com.foxinmy.weixin4j.qy.model.OUserInfo;
import com.foxinmy.weixin4j.qy.model.User;
import com.foxinmy.weixin4j.qy.suite.WeixinSuitePreCodeCreator;
import com.foxinmy.weixin4j.qy.suite.WeixinSuiteTokenCreator;
import com.foxinmy.weixin4j.qy.suite.WeixinTokenSuiteCreator;
import com.foxinmy.weixin4j.token.PerTicketManager;
import com.foxinmy.weixin4j.token.TicketManager;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;

public class SuiteApi
extends QyApi {
    private final TokenManager tokenManager;
    private final TicketManager ticketManager;
    private final TokenManager preCodeManager;

    public SuiteApi(TicketManager ticketManager) {
        this.ticketManager = ticketManager;
        this.tokenManager = new TokenManager((TokenCreator)new WeixinSuiteTokenCreator(ticketManager), ticketManager.getCacheStorager());
        this.preCodeManager = new TokenManager((TokenCreator)new WeixinSuitePreCodeCreator(this.tokenManager, ticketManager.getThirdId()), ticketManager.getCacheStorager());
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public TicketManager getTicketManager() {
        return this.ticketManager;
    }

    public TokenManager getPreCodeManager() {
        return this.preCodeManager;
    }

    public PerTicketManager getPerTicketManager(String authCorpId) {
        return new PerTicketManager(authCorpId, this.ticketManager.getThirdId(), this.ticketManager.getThirdSecret(), this.ticketManager.getCacheStorager());
    }

    public TokenManager getPerTokenManager(String authCorpId) {
        return new TokenManager((TokenCreator)new WeixinTokenSuiteCreator(this.getPerTicketManager(authCorpId), this.tokenManager), this.ticketManager.getCacheStorager());
    }

    public ApiResult setSuiteSession(int ... appids) throws WeixinException {
        String suite_set_session_uri = this.getRequestUri("suite_set_session_uri");
        JSONObject para = new JSONObject();
        para.put("pre_auth_code", (Object)this.preCodeManager.getAccessToken());
        JSONObject appid = new JSONObject();
        appid.put("appid", (Object)appids);
        para.put("session_info", (Object)appid);
        WeixinResponse response = this.weixinExecutor.post(String.format(suite_set_session_uri, this.tokenManager.getAccessToken()), para.toJSONString());
        return response.getAsResult();
    }

    public OUserInfo exchangeAuthInfo(String authCode) throws WeixinException {
        String suite_get_permanent_uri = this.getRequestUri("suite_get_permanent_uri");
        JSONObject obj = new JSONObject();
        obj.put("suite_id", (Object)this.ticketManager.getThirdId());
        obj.put("auth_code", (Object)authCode);
        WeixinResponse response = this.weixinExecutor.post(String.format(suite_get_permanent_uri, this.tokenManager.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        obj.put("corp_info", obj.remove((Object)"auth_corp_info"));
        obj.put("user_info", obj.remove((Object)"auth_user_info"));
        OUserInfo oInfo = (OUserInfo)JSON.toJavaObject((JSON)obj, OUserInfo.class);
        PerTicketManager perTicketManager = this.getPerTicketManager(oInfo.getCorpInfo().getCorpId());
        WeixinTokenSuiteCreator tokenCreator = new WeixinTokenSuiteCreator(perTicketManager, this.tokenManager);
        Token token = new Token(obj.getString("access_token"), obj.getLongValue("expires_in") * 1000L);
        this.ticketManager.getCacheStorager().caching(tokenCreator.key(), (Cacheable)token);
        perTicketManager.cachingTicket(obj.getString("permanent_code"));
        return oInfo;
    }

    public OUserInfo getAuthInfo(String authCorpId) throws WeixinException {
        String suite_get_authinfo_uri = this.getRequestUri("suite_get_authinfo_uri");
        JSONObject obj = new JSONObject();
        obj.put("suite_id", (Object)this.ticketManager.getThirdId());
        obj.put("auth_corpid", (Object)authCorpId);
        obj.put("permanent_code", (Object)this.getPerTicketManager(authCorpId).getAccessTicket());
        WeixinResponse response = this.weixinExecutor.post(String.format(suite_get_authinfo_uri, this.tokenManager.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        obj.put("corp_info", obj.remove((Object)"auth_corp_info"));
        obj.put("user_info", obj.remove((Object)"auth_user_info"));
        return (OUserInfo)JSON.toJavaObject((JSON)obj, OUserInfo.class);
    }

    public AgentInfo getAgent(String authCorpId, int agentid) throws WeixinException {
        String suite_get_agent_uri = this.getRequestUri("suite_get_agent_uri");
        JSONObject obj = new JSONObject();
        obj.put("suite_id", (Object)this.ticketManager.getThirdId());
        obj.put("auth_corpid", (Object)authCorpId);
        obj.put("permanent_code", (Object)this.getPerTicketManager(authCorpId).getAccessTicket());
        obj.put("agentid", (Object)agentid);
        WeixinResponse response = this.weixinExecutor.post(String.format(suite_get_agent_uri, this.tokenManager.getAccessToken()), obj.toJSONString());
        JSONObject jsonObj = response.getAsJson();
        AgentInfo agent = (AgentInfo)JSON.toJavaObject((JSON)jsonObj, AgentInfo.class);
        agent.setAllowUsers(JSON.parseArray((String)jsonObj.getJSONObject("allow_userinfos").getString("user"), User.class));
        agent.setAllowPartys(JSON.parseArray((String)jsonObj.getJSONObject("allow_partys").getString("partyid"), Integer.class));
        agent.setAllowTags(JSON.parseArray((String)jsonObj.getJSONObject("allow_tags").getString("tagid"), Integer.class));
        return agent;
    }

    public ApiResult setAgent(String authCorpId, AgentSetter agentSet) throws WeixinException {
        String suite_set_agent_uri = this.getRequestUri("suite_set_agent_uri");
        JSONObject obj = new JSONObject();
        obj.put("suite_id", (Object)this.ticketManager.getThirdId());
        obj.put("auth_corpid", (Object)authCorpId);
        obj.put("permanent_code", (Object)this.getPerTicketManager(authCorpId).getAccessTicket());
        obj.put("agent", (Object)agentSet);
        WeixinResponse response = this.weixinExecutor.post(String.format(suite_set_agent_uri, this.tokenManager.getAccessToken()), JSON.toJSONString((Object)obj, (SerializeFilter)AgentApi.typeFilter, (SerializerFeature[])new SerializerFeature[0]));
        return response.getAsResult();
    }
}

