/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.cache.Cacheable;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.qy.model.OUserInfo;
import com.foxinmy.weixin4j.qy.type.LoginTargetType;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.util.StringUtil;

public class ProviderApi
extends QyApi {
    private final TokenManager providerTokenManager;
    private final CacheStorager<Token> cacheStorager;

    public ProviderApi(TokenManager providerTokenManager, CacheStorager<Token> cacheStorager) {
        this.providerTokenManager = providerTokenManager;
        this.cacheStorager = cacheStorager;
    }

    public OUserInfo getOUserInfoByCode(String authCode) throws WeixinException {
        String oauth_logininfo_uri = this.getRequestUri("oauth_logininfo_uri");
        WeixinResponse response = this.weixinExecutor.post(String.format(oauth_logininfo_uri, this.providerTokenManager.getAccessToken()), String.format("{\"auth_code\":\"%s\"}", authCode));
        JSONObject obj = response.getAsJson();
        OUserInfo oUser = (OUserInfo)JSON.toJavaObject((JSON)obj, OUserInfo.class);
        obj = obj.getJSONObject("redirect_login_info");
        Token loginInfo = new Token(obj.getString("login_ticket"), obj.getLongValue("expires_in") * 1000L);
        oUser.setRedirectLoginInfo(loginInfo);
        this.cacheStorager.caching(this.getLoginTicketCacheKey(oUser.getCorpInfo().getCorpId()), (Cacheable)oUser.getRedirectLoginInfo());
        return oUser;
    }

    private String getLoginTicketCacheKey(String coprId) {
        return String.format("%sqy_provider_ticket_%s", "weixin4j_", coprId);
    }

    public String getLoginUrl(String corpId, LoginTargetType targetType, int agentId) throws WeixinException {
        Token token = (Token)this.cacheStorager.lookup(this.getLoginTicketCacheKey(corpId));
        if (token == null || StringUtil.isBlank((CharSequence)token.getAccessToken())) {
            throw new WeixinException("maybe oauth first?");
        }
        String oauth_loginurl_uri = this.getRequestUri("oauth_loginurl_uri");
        JSONObject obj = new JSONObject();
        obj.put("login_ticket", (Object)token.getAccessToken());
        obj.put("target", (Object)targetType.name());
        if (agentId > 0) {
            obj.put("agentid", (Object)agentId);
        }
        WeixinResponse response = this.weixinExecutor.post(String.format(oauth_loginurl_uri, this.providerTokenManager.getAccessToken()), obj.toJSONString());
        return response.getAsJson().getString("login_url");
    }
}

