/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.qy.message.CustomeMessage;
import com.foxinmy.weixin4j.qy.message.NotifyMessage;
import com.foxinmy.weixin4j.qy.model.IdParameter;
import com.foxinmy.weixin4j.qy.type.KfType;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.tuple.MpNews;
import com.foxinmy.weixin4j.tuple.NotifyTuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class NotifyApi
extends QyApi {
    private final TokenManager tokenManager;

    public NotifyApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public IdParameter sendNotifyMessage(NotifyMessage message) throws WeixinException {
        NotifyTuple tuple = message.getTuple();
        if (tuple instanceof MpNews && ((MpNews)tuple).getArticles().isEmpty()) {
            throw new WeixinException("notify fail:articles is required");
        }
        Map<String, String> target = message.getTarget().getParameter();
        String msgtype = tuple.getMessageType();
        JSONObject obj = (JSONObject)JSON.toJSON((Object)message);
        obj.put("msgtype", (Object)msgtype);
        obj.put(msgtype, (Object)tuple);
        if (target == null || target.isEmpty()) {
            obj.put("touser", (Object)"@all");
        } else {
            obj.putAll(target);
        }
        String message_send_uri = this.getRequestUri("message_send_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(message_send_uri, token.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        IdParameter idParameter = new IdParameter();
        if (obj.containsKey((Object)"invaliduser")) {
            idParameter.setUserIds(Arrays.asList(obj.getString("invaliduser").split(IdParameter.SEPARATORS)));
        }
        if (obj.containsKey((Object)"invalidparty")) {
            ArrayList<Integer> partyIds = new ArrayList<Integer>();
            for (String id : obj.getString("invalidparty").split(IdParameter.SEPARATORS)) {
                partyIds.add(Integer.parseInt(id));
            }
            idParameter.setPartyIds(partyIds);
        }
        if (obj.containsKey((Object)"invalidtag")) {
            ArrayList<Integer> tagIds = new ArrayList<Integer>();
            for (String id : obj.getString("invalidtag").split(IdParameter.SEPARATORS)) {
                tagIds.add(Integer.parseInt(id));
            }
            idParameter.setTagIds(tagIds);
        }
        return idParameter;
    }

    public ApiResult sendCustomeMessage(CustomeMessage message) throws WeixinException {
        NotifyTuple tuple = message.getTuple();
        String msgtype = tuple.getMessageType();
        JSONObject obj = (JSONObject)JSON.toJSON((Object)message);
        obj.put("msgtype", (Object)msgtype);
        obj.put(msgtype, (Object)tuple);
        String message_kf_send_uri = this.getRequestUri("message_kf_send_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(message_kf_send_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public IdParameter[] getKfList(KfType kfType) throws WeixinException {
        String message_kf_list_uri = this.getRequestUri("message_kf_list_uri");
        if (kfType != null) {
            message_kf_list_uri = message_kf_list_uri + "&type=" + kfType.name();
        }
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(message_kf_list_uri, token.getAccessToken()), new URLParameter[0]);
        JSONObject obj = response.getAsJson();
        return new IdParameter[]{obj.containsKey((Object)"internal") ? (IdParameter)obj.getObject("internal", IdParameter.class) : null, obj.containsKey((Object)"external") ? (IdParameter)obj.getObject("external", IdParameter.class) : null};
    }
}

