/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Button;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.type.ButtonType;
import java.util.ArrayList;
import java.util.List;

public class MenuApi
extends QyApi {
    private final TokenManager tokenManager;

    public MenuApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public ApiResult createMenu(int agentid, List<Button> buttons) throws WeixinException {
        String menu_create_uri = this.getRequestUri("menu_create_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("button", buttons);
        WeixinResponse response = this.weixinExecutor.post(String.format(menu_create_uri, token.getAccessToken(), agentid), JSON.toJSONString((Object)obj, (SerializeFilter)new NameFilter(){

            public String process(Object object, String name, Object value) {
                ButtonType buttonType;
                if (object instanceof Button && name.equals("content") && (buttonType = ((Button)object).getType()) != null) {
                    if (ButtonType.view == buttonType) {
                        return "url";
                    }
                    if (ButtonType.media_id == buttonType || ButtonType.view_limited == buttonType) {
                        return "media_id";
                    }
                    return "key";
                }
                return name;
            }
        }, (SerializerFeature[])new SerializerFeature[0]));
        return response.getAsResult();
    }

    public List<Button> getMenu(int agentid) throws WeixinException {
        String menu_get_uri = this.getRequestUri("menu_get_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(menu_get_uri, token.getAccessToken(), agentid), new URLParameter[0]);
        JSONArray buttons = response.getAsJson().getJSONObject("menu").getJSONArray("button");
        ArrayList<Button> buttonList = new ArrayList<Button>(buttons.size());
        ExtraProcessor processor = new ExtraProcessor(){

            public void processExtra(Object object, String key, Object value) {
                JSONPath.set((Object)object, (String)"$.content", (Object)value);
            }
        };
        for (int i = 0; i < buttons.size(); ++i) {
            buttonList.add((Button)JSON.parseObject((String)buttons.getString(i), Button.class, (ParseProcess)processor, (Feature[])new Feature[0]));
        }
        return buttonList;
    }

    public ApiResult deleteMenu(int agentid) throws WeixinException {
        String menu_delete_uri = this.getRequestUri("menu_delete_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(menu_delete_uri, token.getAccessToken(), agentid), new URLParameter[0]);
        return response.getAsResult();
    }
}

