/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.ContentType;
import com.foxinmy.weixin4j.http.HttpClientException;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpMethod;
import com.foxinmy.weixin4j.http.HttpRequest;
import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.MimeType;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.apache.ByteArrayBody;
import com.foxinmy.weixin4j.http.apache.ContentBody;
import com.foxinmy.weixin4j.http.apache.FormBodyPart;
import com.foxinmy.weixin4j.http.apache.InputStreamBody;
import com.foxinmy.weixin4j.http.message.JsonMessageConverter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.model.media.MediaCounter;
import com.foxinmy.weixin4j.model.media.MediaDownloadResult;
import com.foxinmy.weixin4j.model.media.MediaItem;
import com.foxinmy.weixin4j.model.media.MediaRecord;
import com.foxinmy.weixin4j.model.media.MediaUploadResult;
import com.foxinmy.weixin4j.model.paging.Pageable;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.qy.model.Party;
import com.foxinmy.weixin4j.qy.model.User;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.tuple.MpArticle;
import com.foxinmy.weixin4j.type.MediaType;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.FileUtil;
import com.foxinmy.weixin4j.util.IOUtil;
import com.foxinmy.weixin4j.util.ObjectId;
import com.foxinmy.weixin4j.util.RegexUtil;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

public class MediaApi
extends QyApi {
    private final TokenManager tokenManager;

    public MediaApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public String uploadImage(InputStream is, String fileName) throws WeixinException {
        if (StringUtil.isBlank((CharSequence)fileName)) {
            fileName = ObjectId.get().toHexString();
        }
        if (StringUtil.isBlank((CharSequence)FileUtil.getFileExtension((String)fileName))) {
            fileName = String.format("%s.jpg", fileName);
        }
        String media_uploadimg_uri = this.getRequestUri("media_uploadimg_uri");
        MimeType mimeType = new MimeType("image", FileUtil.getFileExtension((String)fileName));
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(media_uploadimg_uri, token.getAccessToken()), new FormBodyPart[]{new FormBodyPart("media", (ContentBody)new InputStreamBody(is, mimeType.toString(), fileName))});
        return response.getAsJson().getString("url");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaUploadResult uploadMedia(int agentid, InputStream is, String fileName) throws WeixinException {
        String suffixName;
        byte[] content;
        try {
            content = IOUtil.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            throw new WeixinException((Throwable)e);
        }
        if (StringUtil.isBlank((CharSequence)fileName)) {
            fileName = ObjectId.get().toHexString();
        }
        if (StringUtil.isBlank((CharSequence)(suffixName = FileUtil.getFileExtension((String)fileName)))) {
            suffixName = FileUtil.getFileType((InputStream)new ByteArrayInputStream(content));
            fileName = String.format("%s.%s", fileName, suffixName);
        }
        MediaType mediaType = MediaType.file;
        if (",bmp,png,jpeg,jpg,gif,".contains(String.format(",%s,", suffixName))) {
            mediaType = MediaType.image;
        } else if (",mp3,wma,wav,amr,".contains(String.format(",%s,", suffixName))) {
            mediaType = MediaType.voice;
        } else if (",rm,rmvb,wmv,avi,mpg,mpeg,mp4,".contains(String.format(",%s,", suffixName))) {
            mediaType = MediaType.video;
        }
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = null;
        if (agentid > 0) {
            String material_media_upload_uri = this.getRequestUri("material_media_upload_uri");
            response = this.weixinExecutor.post(String.format(material_media_upload_uri, token.getAccessToken(), mediaType.name(), agentid), new FormBodyPart[]{new FormBodyPart("media", (ContentBody)new ByteArrayBody(content, mediaType.getMimeType().toString(), fileName))});
            JSONObject obj = response.getAsJson();
            MediaUploadResult mediaUploadResult = new MediaUploadResult(obj.getString("media_id"), mediaType, new Date(), obj.getString("url"));
            return mediaUploadResult;
        }
        String media_upload_uri = this.getRequestUri("media_upload_uri");
        response = this.weixinExecutor.post(String.format(media_upload_uri, token.getAccessToken(), mediaType.name()), new FormBodyPart[]{new FormBodyPart("media", (ContentBody)new ByteArrayBody(content, mediaType.getMimeType().toString(), fileName))});
        JSONObject obj = response.getAsJson();
        MediaUploadResult mediaUploadResult = new MediaUploadResult(obj.getString("media_id"), (MediaType)obj.getObject("type", MediaType.class), new Date(obj.getLong("created_at") * 1000L), obj.getString("url"));
        return mediaUploadResult;
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public MediaDownloadResult downloadMedia(int agentid, String mediaId) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        try {
            ApiResult result;
            HttpRequest request = null;
            if (agentid > 0) {
                String material_media_download_uri = this.getRequestUri("material_media_download_uri");
                request = new HttpRequest(HttpMethod.GET, String.format(material_media_download_uri, token.getAccessToken(), mediaId, agentid));
            } else {
                String media_download_uri = this.getRequestUri("media_download_uri");
                request = new HttpRequest(HttpMethod.GET, String.format(media_download_uri, token.getAccessToken(), mediaId));
            }
            this.logger.info("weixin request >> " + request.getMethod() + " " + request.getURI().toString());
            HttpResponse response = this.weixinExecutor.getExecuteClient().execute(request);
            byte[] content = IOUtil.toByteArray((InputStream)response.getBody());
            HttpHeaders headers = response.getHeaders();
            String contentType = headers.getFirst("Content-Type");
            String disposition = headers.getFirst("Content-Disposition");
            this.logger.info("weixin response << " + response.getProtocol() + response.getStatus().toString() + "[" + contentType + "]->" + disposition);
            if (JsonMessageConverter.GLOBAL.canConvert(ApiResult.class, response) && !"0".equals((result = (ApiResult)JsonMessageConverter.GLOBAL.convert(ApiResult.class, response)).getReturnCode())) {
                throw new WeixinException(result.getReturnCode(), result.getReturnMsg());
            }
            String fileName = RegexUtil.regexFileNameFromContentDispositionHeader((String)disposition);
            if (StringUtil.isBlank((CharSequence)fileName)) {
                fileName = String.format("%s.%s", mediaId, contentType.split("/")[1]);
            }
            return new MediaDownloadResult(content, ContentType.create((String)contentType), fileName);
        }
        catch (IOException e) {
            throw new WeixinException("I/O Error on getBody", (Throwable)e);
        }
        catch (HttpClientException e) {
            throw new WeixinException((Throwable)e);
        }
    }

    public String uploadMaterialArticle(int agentid, List<MpArticle> articles) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String material_article_upload_uri = this.getRequestUri("material_article_upload_uri");
        JSONObject obj = new JSONObject();
        obj.put("agentid", (Object)agentid);
        JSONObject news = new JSONObject();
        news.put("articles", articles);
        obj.put("mpnews", (Object)news);
        WeixinResponse response = this.weixinExecutor.post(String.format(material_article_upload_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsJson().getString("media_id");
    }

    public ApiResult deleteMaterialMedia(int agentid, String mediaId) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String material_media_del_uri = this.getRequestUri("material_media_del_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(material_media_del_uri, token.getAccessToken(), mediaId, agentid), new URLParameter[0]);
        return response.getAsResult();
    }

    public List<MpArticle> downloadArticle(int agentid, String mediaId) throws WeixinException {
        MediaDownloadResult result = this.downloadMedia(agentid, mediaId);
        byte[] content = result.getContent();
        JSONObject obj = (JSONObject)JSON.parseObject((byte[])content, (int)0, (int)content.length, (CharsetDecoder)Consts.UTF_8.newDecoder(), JSONObject.class, (Feature[])new Feature[0]);
        return JSON.parseArray((String)obj.getJSONObject("mpnews").getString("articles"), MpArticle.class);
    }

    public String updateMaterialArticle(int agentid, String mediaId, List<MpArticle> articles) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String material_article_update_uri = this.getRequestUri("material_article_update_uri");
        JSONObject obj = new JSONObject();
        obj.put("agentid", (Object)agentid);
        JSONObject news = new JSONObject();
        news.put("articles", articles);
        obj.put("mpnews", (Object)news);
        obj.put("media_id", (Object)mediaId);
        WeixinResponse response = this.weixinExecutor.post(String.format(material_article_update_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsJson().getString("media_id");
    }

    public MediaCounter countMaterialMedia(int agentid) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String material_media_count_uri = this.getRequestUri("material_media_count_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(material_media_count_uri, token.getAccessToken(), agentid), new URLParameter[0]);
        JSONObject result = response.getAsJson();
        MediaCounter counter = (MediaCounter)JSON.toJavaObject((JSON)result, MediaCounter.class);
        counter.setNewsCount((long)result.getIntValue("mpnews_count"));
        return counter;
    }

    public MediaRecord listMaterialMedia(int agentid, MediaType mediaType, Pageable pageable) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String material_media_list_uri = this.getRequestUri("material_media_list_uri");
        JSONObject obj = new JSONObject();
        obj.put("agentid", (Object)agentid);
        obj.put("type", (Object)(mediaType == MediaType.news ? "mpnews" : mediaType.name()));
        obj.put("offset", (Object)pageable.getOffset());
        obj.put("count", (Object)pageable.getPageSize());
        WeixinResponse response = this.weixinExecutor.post(String.format(material_media_list_uri, token.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        obj.put("items", obj.remove((Object)"itemlist"));
        MediaRecord mediaRecord = (MediaRecord)JSON.toJavaObject((JSON)obj, MediaRecord.class);
        mediaRecord.setMediaType(mediaType);
        mediaRecord.setPageable(pageable);
        return mediaRecord;
    }

    public List<MediaItem> listAllMaterialMedia(int agentid, MediaType mediaType) throws WeixinException {
        Pageable pageable = new Pageable(1, 20);
        ArrayList<MediaItem> mediaList = new ArrayList<MediaItem>();
        MediaRecord mediaRecord = null;
        while ((mediaRecord = this.listMaterialMedia(agentid, mediaType, pageable)).getItems() != null && !mediaRecord.getItems().isEmpty()) {
            mediaList.addAll(mediaRecord.getItems());
            if (!mediaRecord.getPagedata().hasNext()) break;
            pageable = pageable.next();
        }
        return mediaList;
    }

    public String batchUploadUsers(List<User> users) throws WeixinException {
        return this.batchUpload("batch_syncuser.cvs", users);
    }

    public String batchUploadParties(List<Party> parties) throws WeixinException {
        return this.batchUpload("batch_replaceparty.cvs", parties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> String batchUpload(String batchName, List<T> models) throws WeixinException {
        StringWriter writer = new StringWriter();
        try {
            JSONObject csvObj = JSON.parseObject((String)this.weixinBundle().getString(batchName));
            JSONArray columns = csvObj.getJSONArray("column");
            writer.write(csvObj.getString("header"));
            final LinkedHashMap<String, String> column = new LinkedHashMap<String, String>();
            for (Object col : columns) {
                column.put(col.toString(), "");
            }
            writer.write("\r\n");
            for (T model : models) {
                JSON.toJSONString(model, (SerializeFilter)new PropertyFilter(){

                    public boolean apply(Object object, String name, Object value) {
                        if (column.containsKey(name)) {
                            if (value instanceof Collection) {
                                column.put(name, StringUtil.join(((Collection)value).iterator(), (char)';'));
                            } else {
                                column.put(name, value);
                            }
                        }
                        return true;
                    }
                }, (SerializerFeature[])new SerializerFeature[0]);
                writer.write(StringUtil.join(column.values(), (char)','));
                writer.write("\r\n");
            }
            String string = this.uploadMedia(0, new ByteArrayInputStream(writer.getBuffer().toString().getBytes(Consts.UTF_8)), batchName).getMediaId();
            return string;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
        }
    }
}

