/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.qy.message.ChatMessage;
import com.foxinmy.weixin4j.qy.model.ChatInfo;
import com.foxinmy.weixin4j.qy.model.ChatMute;
import com.foxinmy.weixin4j.qy.type.ChatType;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.tuple.ChatTuple;
import com.foxinmy.weixin4j.util.ObjectId;
import com.foxinmy.weixin4j.util.StringUtil;
import java.util.List;

public class ChatApi
extends QyApi {
    private final TokenManager tokenManager;

    public ChatApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public String createChat(ChatInfo chatInfo) throws WeixinException {
        String chatId = chatInfo.getChatId();
        JSONObject obj = (JSONObject)JSON.toJSON((Object)chatInfo);
        if (StringUtil.isBlank((CharSequence)chatId)) {
            chatId = ObjectId.get().toHexString();
            obj.put("chatid", (Object)chatId);
        }
        String message_chat_create_uri = this.getRequestUri("message_chat_create_uri");
        Token token = (Token)this.tokenManager.getCache();
        this.weixinExecutor.post(String.format(message_chat_create_uri, token.getAccessToken()), obj.toJSONString());
        return chatId;
    }

    public ChatInfo getChat(String chatId) throws WeixinException {
        String message_chat_get_uri = this.getRequestUri("message_chat_get_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(message_chat_get_uri, token.getAccessToken(), chatId), new URLParameter[0]);
        return (ChatInfo)response.getAsJson().getObject("chat_info", ChatInfo.class);
    }

    public ApiResult updateChat(ChatInfo chatInfo, String operator, List<String> addUsers, List<String> deleteUsers) throws WeixinException {
        JSONObject obj = (JSONObject)JSON.toJSON((Object)chatInfo);
        obj.remove((Object)"userlist");
        obj.put("op_user", (Object)operator);
        obj.put("add_user_list", addUsers);
        obj.put("del_user_list", deleteUsers);
        String message_chat_update_uri = this.getRequestUri("message_chat_update_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(message_chat_update_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult quitChat(String chatId, String operator) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("chatid", (Object)chatId);
        obj.put("op_user", (Object)operator);
        String message_chat_quit_uri = this.getRequestUri("message_chat_quit_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(message_chat_quit_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsResult();
    }

    public ApiResult clearChatNotify(String targetId, String owner, ChatType chatType) throws WeixinException {
        JSONObject chat = new JSONObject();
        chat.put("type", (Object)chatType.name());
        chat.put("id", (Object)targetId);
        String message_chat_clearnotify_uri = this.getRequestUri("message_chat_clearnotify_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(message_chat_clearnotify_uri, token.getAccessToken()), String.format("{\"op_user\": \"%s\",\"chat\":%s", owner, chat.toJSONString()));
        return response.getAsResult();
    }

    public List<String> setChatMute(List<ChatMute> chatMutes) throws WeixinException {
        JSONObject mute = new JSONObject();
        mute.put("user_mute_list", chatMutes);
        String message_chat_setmute_uri = this.getRequestUri("message_chat_setmute_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(message_chat_setmute_uri, token.getAccessToken()), mute.toJSONString());
        return JSON.parseArray((String)response.getAsJson().getString("invaliduser"), String.class);
    }

    public ApiResult sendChatMessage(ChatMessage message) throws WeixinException {
        ChatTuple tuple = message.getChatTuple();
        String msgtype = tuple.getMessageType();
        JSONObject msg = new JSONObject();
        JSONObject receiver = new JSONObject();
        receiver.put("id", (Object)message.getTargetId());
        receiver.put("type", (Object)message.getChatType().name());
        msg.put("receiver", (Object)receiver);
        msg.put("sender", (Object)message.getSenderId());
        msg.put("msgtype", (Object)msgtype);
        msg.put(msgtype, (Object)tuple);
        String message_chat_send_uri = this.getRequestUri("message_chat_send_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(message_chat_send_uri, token.getAccessToken()), msg.toJSONString());
        return response.getAsResult();
    }
}

