/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.qy.model.BatchResult;
import com.foxinmy.weixin4j.qy.model.Callback;
import com.foxinmy.weixin4j.qy.model.IdParameter;
import com.foxinmy.weixin4j.token.TokenManager;

public class BatchApi
extends QyApi {
    private final TokenManager tokenManager;

    public BatchApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public String inviteUser(IdParameter parameter, Callback callback, String tips) throws WeixinException {
        String batch_inviteuser_uri = this.getRequestUri("batch_inviteuser_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.putAll(parameter.getParameter());
        obj.put("callback", (Object)callback);
        obj.put("invite_tips", (Object)tips);
        WeixinResponse response = this.weixinExecutor.post(String.format(batch_inviteuser_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsJson().getString("jobid");
    }

    public String syncUser(String mediaId, Callback callback) throws WeixinException {
        String batch_syncuser_uri = this.getRequestUri("batch_syncuser_uri");
        return this.batch(batch_syncuser_uri, mediaId, callback);
    }

    private String batch(String batchUrl, String mediaId, Callback callback) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = new JSONObject();
        obj.put("media_id", (Object)mediaId);
        obj.put("callback", (Object)callback);
        WeixinResponse response = this.weixinExecutor.post(String.format(batchUrl, token.getAccessToken()), obj.toJSONString());
        return response.getAsJson().getString("jobid");
    }

    public String replaceUser(String mediaId, Callback callback) throws WeixinException {
        String batch_replaceuser_uri = this.getRequestUri("batch_replaceuser_uri");
        return this.batch(batch_replaceuser_uri, mediaId, callback);
    }

    public String replaceParty(String mediaId, Callback callback) throws WeixinException {
        String batch_replaceparty_uri = this.getRequestUri("batch_replaceparty_uri");
        return this.batch(batch_replaceparty_uri, mediaId, callback);
    }

    public BatchResult getBatchResult(String jobId) throws WeixinException {
        Token token = (Token)this.tokenManager.getCache();
        String batch_getresult_uri = this.getRequestUri("batch_getresult_uri");
        WeixinResponse response = this.weixinExecutor.get(String.format(batch_getresult_uri, token.getAccessToken(), jobId), new URLParameter[0]);
        return (BatchResult)((Object)response.getAsObject((TypeReference)new TypeReference<BatchResult>(){}));
    }
}

