/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.URLParameter;
import com.foxinmy.weixin4j.http.weixin.ApiResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.qy.model.AgentInfo;
import com.foxinmy.weixin4j.qy.model.AgentOverview;
import com.foxinmy.weixin4j.qy.model.AgentSetter;
import com.foxinmy.weixin4j.qy.model.User;
import com.foxinmy.weixin4j.token.TokenManager;
import java.util.List;

public class AgentApi
extends QyApi {
    private final TokenManager tokenManager;
    public static final ValueFilter typeFilter = new ValueFilter(){

        public Object process(Object object, String name, Object value) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1 : 0;
            }
            if (value instanceof Enum) {
                return ((Enum)value).ordinal();
            }
            return value;
        }
    };

    public AgentApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public AgentInfo getAgent(int agentid) throws WeixinException {
        String agent_get_uri = this.getRequestUri("agent_get_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(agent_get_uri, token.getAccessToken(), agentid), new URLParameter[0]);
        JSONObject jsonObj = response.getAsJson();
        AgentInfo agent = (AgentInfo)JSON.toJavaObject((JSON)jsonObj, AgentInfo.class);
        agent.setAllowUsers(JSON.parseArray((String)jsonObj.getJSONObject("allow_userinfos").getString("user"), User.class));
        agent.setAllowPartys(JSON.parseArray((String)jsonObj.getJSONObject("allow_partys").getString("partyid"), Integer.class));
        agent.setAllowTags(JSON.parseArray((String)jsonObj.getJSONObject("allow_tags").getString("tagid"), Integer.class));
        return agent;
    }

    public ApiResult setAgent(AgentSetter agentSet) throws WeixinException {
        String agent_set_uri = this.getRequestUri("agent_set_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(agent_set_uri, token.getAccessToken()), JSON.toJSONString((Object)agentSet, (SerializeFilter)typeFilter, (SerializerFeature[])new SerializerFeature[0]));
        return response.getAsResult();
    }

    public List<AgentOverview> listAgentOverview() throws WeixinException {
        String agent_list_uri = this.getRequestUri("agent_list_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(agent_list_uri, token.getAccessToken()), new URLParameter[0]);
        return JSON.parseArray((String)response.getAsJson().getString("agentlist"), AgentOverview.class);
    }
}

