/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy;

import com.alibaba.fastjson.JSON;
import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.model.WeixinAccount;
import com.foxinmy.weixin4j.qy.WeixinProxy;
import com.foxinmy.weixin4j.qy.api.ProviderApi;
import com.foxinmy.weixin4j.qy.api.SuiteApi;
import com.foxinmy.weixin4j.qy.model.OUserInfo;
import com.foxinmy.weixin4j.qy.model.WeixinQyAccount;
import com.foxinmy.weixin4j.qy.token.WeixinProviderTokenCreator;
import com.foxinmy.weixin4j.qy.type.LoginTargetType;
import com.foxinmy.weixin4j.setting.Weixin4jSettings;
import com.foxinmy.weixin4j.token.TicketManager;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.StringUtil;
import com.foxinmy.weixin4j.util.Weixin4jConfigUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WeixinSuiteProxy {
    private Map<String, SuiteApi> suiteMap;
    private ProviderApi providerApi;
    private final Weixin4jSettings<WeixinQyAccount> settings;
    public static final String VERSION = "1.7.1";

    public WeixinSuiteProxy() {
        this((Weixin4jSettings<WeixinQyAccount>)new Weixin4jSettings(JSON.parseObject((String)Weixin4jConfigUtil.getValue((String)"account"), WeixinQyAccount.class)));
    }

    public WeixinSuiteProxy(Weixin4jSettings<WeixinQyAccount> settings) {
        this.settings = settings;
        List<WeixinAccount> suites = ((WeixinQyAccount)((Object)settings.getAccount())).getSuites();
        if (suites != null && !suites.isEmpty()) {
            this.suiteMap = new HashMap<String, SuiteApi>(suites.size());
            for (WeixinAccount suite : suites) {
                this.suiteMap.put(suite.getId(), new SuiteApi(new TicketManager(suite.getId(), suite.getSecret(), settings.getCacheStorager0())));
            }
            this.suiteMap.put(null, this.suiteMap.get(suites.get(0).getId()));
        }
        if (StringUtil.isNotBlank((CharSequence)((WeixinQyAccount)((Object)settings.getAccount())).getId()) && StringUtil.isNotBlank((CharSequence)((WeixinQyAccount)((Object)settings.getAccount())).getProviderSecret())) {
            this.providerApi = new ProviderApi(new TokenManager((TokenCreator)new WeixinProviderTokenCreator(((WeixinQyAccount)((Object)settings.getAccount())).getId(), ((WeixinQyAccount)((Object)settings.getAccount())).getProviderSecret()), settings.getCacheStorager0()), (CacheStorager<Token>)settings.getCacheStorager0());
        }
    }

    public WeixinQyAccount getWeixinAccount() {
        return (WeixinQyAccount)((Object)this.settings.getAccount());
    }

    public SuiteApi suite() {
        return this.suiteMap.get(null);
    }

    public SuiteApi suite(String suiteId) {
        return this.suiteMap.get(suiteId);
    }

    public String getPreSuiteTicket(String suiteId) throws WeixinException {
        Token token = this.suite(suiteId).getTicketManager().getTicket();
        if (token == null || StringUtil.isBlank((CharSequence)token.getAccessToken())) {
            throw new WeixinException("maybe oauth first?");
        }
        return token.getAccessToken();
    }

    public void cacheSuiteTicket(String suiteId, String suiteTicket) throws WeixinException {
        this.suite(suiteId).getTicketManager().cachingTicket(suiteTicket);
    }

    public String getSuiteAuthorizeURL(String suiteId) throws WeixinException {
        String redirectUri = Weixin4jConfigUtil.getValue((String)"suite.oauth.redirect.uri");
        return this.getSuiteAuthorizeURL(suiteId, redirectUri, "state");
    }

    public String getSuiteAuthorizeURL(String suiteId, String redirectUri, String state) throws WeixinException {
        try {
            return String.format("https://qy.weixin.qq.com/cgi-bin/loginpage?suite_id=%s&pre_auth_code=%s&redirect_uri=%s&state=%s", suiteId, this.getPreSuiteTicket(suiteId), URLEncoder.encode(redirectUri, Consts.UTF_8.name()), state);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public OUserInfo getOUserInfoByCode(String authCode) throws WeixinException {
        return this.providerApi.getOUserInfoByCode(authCode);
    }

    public String getLoginUrl(String corpId, LoginTargetType targetType, int agentId) throws WeixinException {
        return this.providerApi.getLoginUrl(corpId, targetType, agentId);
    }

    public WeixinProxy getWeixinProxy(String suiteId, String authCorpId) {
        return new WeixinProxy(this.suite(suiteId).getPerTicketManager(authCorpId), this.suite(suiteId).getTokenManager());
    }
}

