/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.token;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TokenCreator;

public class WeixinTokenCreator
extends TokenCreator {
    private final String corpid;
    private final String corpsecret;

    public WeixinTokenCreator(String corpid, String corpsecret) {
        this.corpid = corpid;
        this.corpsecret = corpsecret;
    }

    public String key0() {
        return String.format("qy_token_%s", this.corpid);
    }

    public Token create() throws WeixinException {
        String tokenUrl = String.format("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=%s&corpsecret=%s", this.corpid, this.corpsecret);
        WeixinResponse response = this.weixinExecutor.get(tokenUrl);
        JSONObject result = response.getAsJson();
        return new Token(result.getString("access_token"), result.getLongValue("expires_in") * 1000L);
    }
}

