/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.token;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.type.TicketType;

public class WeixinTicketCreator
extends TokenCreator {
    private final String corpid;
    private final TicketType ticketType;
    private final TokenManager weixinTokenManager;

    public WeixinTicketCreator(String corpid, TicketType ticketType, TokenManager weixinTokenManager) {
        this.corpid = corpid;
        this.ticketType = ticketType;
        this.weixinTokenManager = weixinTokenManager;
    }

    public String key0() {
        return String.format("qy_ticket_%s_%s", this.ticketType.name(), this.corpid);
    }

    public Token create() throws WeixinException {
        WeixinResponse response = null;
        response = this.ticketType == TicketType.jsapi ? this.weixinExecutor.get(String.format("https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token=%s", ((Token)this.weixinTokenManager.getCache()).getAccessToken())) : this.weixinExecutor.get(String.format("https://qyapi.weixin.qq.com/cgi-bin/ticket/get?access_token=%s&type=%s", ((Token)this.weixinTokenManager.getCache()).getAccessToken(), this.ticketType.name()));
        JSONObject result = response.getAsJson();
        return new Token(result.getString("ticket"), result.getLong("expires_in") * 1000L);
    }
}

