/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.suite;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.suite.SuitePerCodeManager;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;

public class WeixinTokenSuiteCreator
extends TokenCreator {
    private final SuitePerCodeManager perCodeManager;
    private final TokenManager suiteTokenManager;

    public WeixinTokenSuiteCreator(SuitePerCodeManager perCodeManager, TokenManager suiteTokenManager) {
        this.perCodeManager = perCodeManager;
        this.suiteTokenManager = suiteTokenManager;
    }

    public String key0() {
        return String.format("qy_token_suite_%s_%s", this.perCodeManager.getSuiteId(), this.perCodeManager.getAuthCorpId());
    }

    public Token create() throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("suite_id", (Object)this.perCodeManager.getSuiteId());
        obj.put("auth_corpid", (Object)this.perCodeManager.getAuthCorpId());
        obj.put("permanent_code", (Object)this.perCodeManager.getPermanentCode());
        WeixinResponse response = this.weixinExecutor.post(String.format("https://qyapi.weixin.qq.com/cgi-bin/service/get_corp_token?suite_access_token=%s", this.suiteTokenManager.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        return new Token(obj.getString("access_token"), obj.getLongValue("expires_in") * 1000L);
    }
}

