/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.suite;

import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.cache.Cacheable;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.model.Token;

public class SuiteTicketManager {
    private final String suiteId;
    private final String suiteSecret;
    private final CacheStorager<Token> cacheStorager;

    public SuiteTicketManager(String suiteId, String suiteSecret, CacheStorager<Token> cacheStorager) {
        this.suiteId = suiteId;
        this.suiteSecret = suiteSecret;
        this.cacheStorager = cacheStorager;
    }

    public String getTicket() throws WeixinException {
        return ((Token)this.cacheStorager.lookup(this.getCacheKey())).getAccessToken();
    }

    public String getCacheKey() {
        return String.format("%sqy_suite_ticket_%s", "weixin4j_", this.suiteId);
    }

    public void cachingTicket(String ticket) throws WeixinException {
        Token token = new Token(ticket);
        this.cacheStorager.caching(this.getCacheKey(), (Cacheable)token);
    }

    public String getSuiteId() {
        return this.suiteId;
    }

    public String getSuiteSecret() {
        return this.suiteSecret;
    }

    public CacheStorager<Token> getCacheStorager() {
        return this.cacheStorager;
    }
}

