/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.suite;

import com.foxinmy.weixin4j.cache.CacheStorager;
import com.foxinmy.weixin4j.cache.Cacheable;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.model.Token;

public class SuitePerCodeManager {
    private final String authCorpId;
    private final String suiteId;
    private final CacheStorager<Token> cacheStorager;

    public SuitePerCodeManager(String authCorpId, String suiteId, CacheStorager<Token> cacheStorager) {
        this.authCorpId = authCorpId;
        this.suiteId = suiteId;
        this.cacheStorager = cacheStorager;
    }

    public void cachingPermanentCode(String permanentCode) throws WeixinException {
        Token token = new Token(permanentCode);
        this.cacheStorager.caching(this.getCacheKey(), (Cacheable)token);
    }

    public String getCacheKey() {
        return String.format("%sqy_suite_percode_%s_%s", "weixin4j_", this.suiteId, this.authCorpId);
    }

    public String getPermanentCode() throws WeixinException {
        return ((Token)this.cacheStorager.lookup(this.getCacheKey())).getAccessToken();
    }

    public String getSuiteId() {
        return this.suiteId;
    }

    public String getAuthCorpId() {
        return this.authCorpId;
    }

    public CacheStorager<Token> getCacheStorager() {
        return this.cacheStorager;
    }
}

