/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.model.Gender;
import com.foxinmy.weixin4j.qy.type.UserStatus;
import com.foxinmy.weixin4j.util.NameValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class User
implements Serializable {
    private static final long serialVersionUID = 4747301605060801611L;
    @JSONField(name="userid")
    private String userId;
    private String name;
    @JSONField(name="department")
    private List<Integer> partyIds;
    private String position;
    private String mobile;
    private Integer gender;
    private String tel;
    private String email;
    @JSONField(name="weixinid")
    private String weixinId;
    private String avatar;
    private Integer status;
    private List<NameValue> extattr;

    protected User() {
    }

    public User(String userId, String name) {
        this.userId = userId;
        this.name = name;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getName() {
        return this.name;
    }

    public List<Integer> getPartyIds() {
        return this.partyIds;
    }

    public void setPartyIds(Integer ... partyIds) {
        this.partyIds = Arrays.asList(partyIds);
    }

    public String getPosition() {
        return this.position;
    }

    public String getMobile() {
        return this.mobile;
    }

    public Integer getGender() {
        return this.gender;
    }

    @JSONField(serialize=false)
    public Gender getFormatGender() {
        if (this.gender != null) {
            if (this.gender == 0) {
                return Gender.male;
            }
            if (this.gender == 1) {
                return Gender.female;
            }
            return Gender.unknown;
        }
        return null;
    }

    public String getTel() {
        return this.tel;
    }

    public String getEmail() {
        return this.email;
    }

    public String getWeixinId() {
        return this.weixinId;
    }

    public String getAvatar() {
        return this.avatar;
    }

    @JSONField(serialize=false)
    public UserStatus getFormatStatus() {
        if (this.status != null) {
            for (UserStatus userStatus : UserStatus.values()) {
                if (userStatus.getVal() != this.status.intValue()) continue;
                return userStatus;
            }
        }
        return null;
    }

    public Integer getStatus() {
        return this.status;
    }

    @JSONField(serialize=false)
    public Boolean getFormatEnable() {
        if (this.status != null) {
            return this.status != 2;
        }
        return Boolean.FALSE;
    }

    public void setEnable(boolean enable) {
        this.status = enable ? 1 : 0;
    }

    public List<NameValue> getExtattr() {
        return this.extattr;
    }

    public void setExtattr(List<NameValue> extattr) {
        this.extattr = extattr;
    }

    public void setExtattr(NameValue ... extattr) {
        this.extattr = Arrays.asList(extattr);
    }

    public void pushExattr(String name, String value) {
        this.extattr.add(new NameValue(name, value));
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPartyIds(List<Integer> partyIds) {
        this.partyIds = partyIds;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setWeixinId(String weixinId) {
        this.weixinId = weixinId;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String toString() {
        return "User [userId=" + this.userId + ", name=" + this.name + ", partyIds=" + this.partyIds + ", position=" + this.position + ", mobile=" + this.mobile + ", gender=" + this.gender + ", tel=" + this.tel + ", email=" + this.email + ", weixinId=" + this.weixinId + ", avatar=" + this.avatar + ", status=" + this.status + ", extattr=" + this.extattr + "]";
    }
}

