/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.jssdk;

import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.jssdk.JSSDKContactParameter;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.util.DateUtil;
import com.foxinmy.weixin4j.util.DigestUtil;
import com.foxinmy.weixin4j.util.MapUtil;
import com.foxinmy.weixin4j.util.RandomUtil;
import java.util.HashMap;

public class JSSDKContactConfigurator {
    private final TokenManager ticketTokenManager;
    private JSSDKContactParameter contactParameter;

    public JSSDKContactConfigurator(TokenManager ticketTokenManager) {
        this.ticketTokenManager = ticketTokenManager;
        this.contactParameter = new JSSDKContactParameter();
    }

    public JSSDKContactConfigurator partyIds(Integer ... partyIds) {
        this.contactParameter.putPartyIds(partyIds);
        return this;
    }

    public JSSDKContactConfigurator tagIds(Integer ... tagIds) {
        this.contactParameter.putTagIds(tagIds);
        return this;
    }

    public JSSDKContactConfigurator userIds(String ... userIds) {
        this.contactParameter.putUserIds(userIds);
        return this;
    }

    public JSSDKContactConfigurator singleMode() {
        this.contactParameter.setMode("single");
        return this;
    }

    public JSSDKContactConfigurator multiMode() {
        this.contactParameter.setMode("multi");
        return this;
    }

    public JSSDKContactConfigurator limitDepartment() {
        this.contactParameter.putLimitType("department");
        return this;
    }

    public JSSDKContactConfigurator limitTag() {
        this.contactParameter.putLimitType("tag");
        return this;
    }

    public JSSDKContactConfigurator limitUser() {
        this.contactParameter.putLimitType("user");
        return this;
    }

    public JSSDKContactConfigurator selectedDepartmentIds(Integer ... selectedDepartmentIds) {
        this.contactParameter.putSelectedDepartmentIds(selectedDepartmentIds);
        return this;
    }

    public JSSDKContactConfigurator selectedTagIds(Integer ... selectedTagIds) {
        this.contactParameter.putSelectedTagIds(selectedTagIds);
        return this;
    }

    public JSSDKContactConfigurator selectedUserIds(String ... selectedUserIds) {
        this.contactParameter.putSelectedUserIds(selectedUserIds);
        return this;
    }

    public String toJSONConfig(String url) throws WeixinException {
        return this.toJSONConfig(url, this.contactParameter);
    }

    public String toJSONConfig(String url, JSSDKContactParameter parameter) throws WeixinException {
        HashMap<String, String> signMap = new HashMap<String, String>();
        String timestamp = DateUtil.timestamp2string();
        String noncestr = RandomUtil.generateString((int)24);
        Token token = (Token)this.ticketTokenManager.getCache();
        signMap.put("timestamp", timestamp);
        signMap.put("nonceStr", noncestr);
        signMap.put("group_ticket", token.getAccessToken());
        signMap.put("url", url);
        String sign = DigestUtil.SHA1((String)MapUtil.toJoinString(signMap, (boolean)false, (boolean)true));
        JSONObject config = new JSONObject();
        config.put("signature", (Object)sign);
        config.put("groupId", token.getExtra().get("group_id"));
        config.put("timestamp", (Object)timestamp);
        config.put("noncestr", (Object)noncestr);
        config.put("params", (Object)parameter);
        return config.toJSONString();
    }
}

