/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.JsonResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.qy.model.Contacts;
import com.foxinmy.weixin4j.qy.model.IdParameter;
import com.foxinmy.weixin4j.qy.model.Tag;
import com.foxinmy.weixin4j.qy.model.User;
import com.foxinmy.weixin4j.token.TokenManager;
import java.util.Arrays;
import java.util.List;

public class TagApi
extends QyApi {
    private final TokenManager tokenManager;

    public TagApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public int createTag(Tag tag) throws WeixinException {
        String tag_create_uri = this.getRequestUri("tag_create_uri");
        Token token = (Token)this.tokenManager.getCache();
        JSONObject obj = (JSONObject)JSON.toJSON((Object)tag);
        if (obj.getIntValue("tagid") <= 0) {
            obj.remove((Object)"tagid");
        }
        WeixinResponse response = this.weixinExecutor.post(String.format(tag_create_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsJson().getIntValue("tagid");
    }

    public JsonResult updateTag(Tag tag) throws WeixinException {
        String tag_update_uri = this.getRequestUri("tag_update_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(tag_update_uri, token.getAccessToken()), JSON.toJSONString((Object)tag));
        return response.getAsJsonResult();
    }

    public JsonResult deleteTag(int tagId) throws WeixinException {
        String tag_delete_uri = this.getRequestUri("tag_delete_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(tag_delete_uri, token.getAccessToken(), tagId));
        return response.getAsJsonResult();
    }

    public List<Tag> listTag() throws WeixinException {
        String tag_list_uri = this.getRequestUri("tag_list_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(tag_list_uri, token.getAccessToken()));
        return JSON.parseArray((String)response.getAsJson().getString("taglist"), Tag.class);
    }

    public Contacts getTagUsers(int tagId) throws WeixinException {
        String tag_get_user_uri = this.getRequestUri("tag_get_user_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(tag_get_user_uri, token.getAccessToken(), tagId));
        JSONObject obj = response.getAsJson();
        Contacts contacts = new Contacts();
        contacts.setUsers(JSON.parseArray((String)obj.getString("userlist"), User.class));
        contacts.setPartyIds(JSON.parseArray((String)obj.getString("partylist"), Integer.class));
        contacts.putTagIds(tagId);
        return contacts;
    }

    public IdParameter addTagUsers(int tagId, List<String> userIds, List<Integer> partyIds) throws WeixinException {
        String tag_add_user_uri = this.getRequestUri("tag_add_user_uri");
        return this.excuteUsers(tag_add_user_uri, tagId, userIds, partyIds);
    }

    public IdParameter deleteTagUsers(int tagId, List<String> userIds, List<Integer> partyIds) throws WeixinException {
        String tag_delete_user_uri = this.getRequestUri("tag_delete_user_uri");
        return this.excuteUsers(tag_delete_user_uri, tagId, userIds, partyIds);
    }

    private IdParameter excuteUsers(String uri, int tagId, List<String> userIds, List<Integer> partyIds) throws WeixinException {
        JSONObject obj = new JSONObject();
        obj.put("tagid", (Object)tagId);
        obj.put("userlist", userIds);
        obj.put("partylist", partyIds);
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(uri, token.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        IdParameter idParameter = new IdParameter();
        if (obj.containsKey((Object)"invalidlist")) {
            idParameter.setUserIds(Arrays.asList(obj.getString("invalidlist").split(IdParameter.SEPARATORS)));
        }
        if (obj.containsKey((Object)"partylist")) {
            idParameter.setPartyIds(JSON.parseArray((String)obj.getString("partylist"), Integer.class));
        }
        return idParameter;
    }
}

