/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.foxinmy.weixin4j.cache.Cacheable;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.JsonResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.api.AgentApi;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.qy.model.AgentInfo;
import com.foxinmy.weixin4j.qy.model.AgentSetter;
import com.foxinmy.weixin4j.qy.model.OUserInfo;
import com.foxinmy.weixin4j.qy.model.User;
import com.foxinmy.weixin4j.qy.suite.SuitePerCodeManager;
import com.foxinmy.weixin4j.qy.suite.SuiteTicketManager;
import com.foxinmy.weixin4j.qy.suite.WeixinSuitePreCodeCreator;
import com.foxinmy.weixin4j.qy.suite.WeixinSuiteTokenCreator;
import com.foxinmy.weixin4j.qy.suite.WeixinTokenSuiteCreator;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;

public class SuiteApi
extends QyApi {
    private final TokenManager suiteTokenManager;
    private final SuiteTicketManager suiteTicketManager;
    private final TokenManager suitePreCodeManager;

    public SuiteApi(SuiteTicketManager suiteTicketManager) {
        this.suiteTicketManager = suiteTicketManager;
        this.suiteTokenManager = new TokenManager((TokenCreator)new WeixinSuiteTokenCreator(suiteTicketManager), suiteTicketManager.getCacheStorager());
        this.suitePreCodeManager = new TokenManager((TokenCreator)new WeixinSuitePreCodeCreator(this.suiteTokenManager, suiteTicketManager.getSuiteId()), suiteTicketManager.getCacheStorager());
    }

    public TokenManager getSuiteTokenManager() {
        return this.suiteTokenManager;
    }

    public SuiteTicketManager getTicketManager() {
        return this.suiteTicketManager;
    }

    public TokenManager getPreCodeManager() {
        return this.suitePreCodeManager;
    }

    public SuitePerCodeManager getPerCodeManager(String authCorpId) {
        return new SuitePerCodeManager(authCorpId, this.suiteTicketManager.getSuiteId(), this.suiteTicketManager.getCacheStorager());
    }

    public TokenManager getTokenSuiteManager(String authCorpId) {
        return new TokenManager((TokenCreator)new WeixinTokenSuiteCreator(this.getPerCodeManager(authCorpId), this.suiteTokenManager), this.suiteTicketManager.getCacheStorager());
    }

    public JsonResult setSuiteSession(int ... appids) throws WeixinException {
        String suite_set_session_uri = this.getRequestUri("suite_set_session_uri");
        JSONObject para = new JSONObject();
        para.put("pre_auth_code", (Object)this.suitePreCodeManager.getAccessToken());
        JSONObject appid = new JSONObject();
        appid.put("appid", (Object)appids);
        para.put("session_info", (Object)appid);
        WeixinResponse response = this.weixinExecutor.post(String.format(suite_set_session_uri, this.suiteTokenManager.getAccessToken()), para.toJSONString());
        return response.getAsJsonResult();
    }

    public OUserInfo exchangePermanentCode(String authCode) throws WeixinException {
        String suite_get_permanent_uri = this.getRequestUri("suite_get_permanent_uri");
        JSONObject obj = new JSONObject();
        obj.put("suite_id", (Object)this.suiteTicketManager.getSuiteId());
        obj.put("auth_code", (Object)authCode);
        WeixinResponse response = this.weixinExecutor.post(String.format(suite_get_permanent_uri, this.suiteTokenManager.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        obj.put("corp_info", obj.remove((Object)"auth_corp_info"));
        obj.put("user_info", obj.remove((Object)"auth_user_info"));
        OUserInfo oInfo = (OUserInfo)JSON.toJavaObject((JSON)obj, OUserInfo.class);
        SuitePerCodeManager suitePerCodeManager = this.getPerCodeManager(oInfo.getCorpInfo().getCorpId());
        WeixinTokenSuiteCreator tokenCreator = new WeixinTokenSuiteCreator(suitePerCodeManager, this.suiteTokenManager);
        Token token = new Token(obj.getString("access_token"), obj.getLongValue("expires_in") * 1000L);
        this.suiteTicketManager.getCacheStorager().caching(tokenCreator.key(), (Cacheable)token);
        suitePerCodeManager.cachingPermanentCode(obj.getString("permanent_code"));
        return oInfo;
    }

    public OUserInfo getOAuthInfo(String authCorpId) throws WeixinException {
        String suite_get_authinfo_uri = this.getRequestUri("suite_get_authinfo_uri");
        JSONObject obj = new JSONObject();
        obj.put("suite_id", (Object)this.suiteTicketManager.getSuiteId());
        obj.put("auth_corpid", (Object)authCorpId);
        obj.put("permanent_code", (Object)this.getPerCodeManager(authCorpId).getPermanentCode());
        WeixinResponse response = this.weixinExecutor.post(String.format(suite_get_authinfo_uri, this.suiteTokenManager.getAccessToken()), obj.toJSONString());
        obj = response.getAsJson();
        obj.put("corp_info", obj.remove((Object)"auth_corp_info"));
        obj.put("user_info", obj.remove((Object)"auth_user_info"));
        return (OUserInfo)JSON.toJavaObject((JSON)obj, OUserInfo.class);
    }

    public AgentInfo getAgent(String authCorpId, int agentid) throws WeixinException {
        String suite_get_agent_uri = this.getRequestUri("suite_get_agent_uri");
        JSONObject obj = new JSONObject();
        obj.put("suite_id", (Object)this.suiteTicketManager.getSuiteId());
        obj.put("auth_corpid", (Object)authCorpId);
        obj.put("permanent_code", (Object)this.getPerCodeManager(authCorpId).getPermanentCode());
        obj.put("agentid", (Object)agentid);
        WeixinResponse response = this.weixinExecutor.post(String.format(suite_get_agent_uri, this.suiteTokenManager.getAccessToken()), obj.toJSONString());
        JSONObject jsonObj = response.getAsJson();
        AgentInfo agent = (AgentInfo)JSON.toJavaObject((JSON)jsonObj, AgentInfo.class);
        agent.setAllowUsers(JSON.parseArray((String)jsonObj.getJSONObject("allow_userinfos").getString("user"), User.class));
        agent.setAllowPartys(JSON.parseArray((String)jsonObj.getJSONObject("allow_partys").getString("partyid"), Integer.class));
        agent.setAllowTags(JSON.parseArray((String)jsonObj.getJSONObject("allow_tags").getString("tagid"), Integer.class));
        return agent;
    }

    public JsonResult setAgent(String authCorpId, AgentSetter agentSet) throws WeixinException {
        String suite_set_agent_uri = this.getRequestUri("suite_set_agent_uri");
        JSONObject obj = new JSONObject();
        obj.put("suite_id", (Object)this.suiteTicketManager.getSuiteId());
        obj.put("auth_corpid", (Object)authCorpId);
        obj.put("permanent_code", (Object)this.getPerCodeManager(authCorpId).getPermanentCode());
        obj.put("agent", (Object)agentSet);
        WeixinResponse response = this.weixinExecutor.post(String.format(suite_set_agent_uri, this.suiteTokenManager.getAccessToken()), JSON.toJSONString((Object)obj, (SerializeFilter)AgentApi.typeFilter, (SerializerFeature[])new SerializerFeature[0]));
        return response.getAsJsonResult();
    }
}

