/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.JsonResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.Token;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.qy.model.Party;
import com.foxinmy.weixin4j.token.TokenManager;
import java.util.List;

public class PartyApi
extends QyApi {
    private final TokenManager tokenManager;

    public PartyApi(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public int createParty(Party party) throws WeixinException {
        String department_create_uri = this.getRequestUri("department_create_uri");
        JSONObject obj = (JSONObject)JSON.toJSON((Object)party);
        if (party.getParentId() < 1) {
            obj.remove((Object)"parentid");
        }
        if (party.getId() < 1) {
            obj.remove((Object)"id");
        }
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(department_create_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsJson().getIntValue("id");
    }

    public JsonResult updateParty(Party party) throws WeixinException {
        if (party.getId() < 1) {
            throw new WeixinException("department id must gt 1");
        }
        String department_update_uri = this.getRequestUri("department_update_uri");
        JSONObject obj = (JSONObject)JSON.toJSON((Object)party);
        if (party.getParentId() < 1) {
            obj.remove((Object)"parentid");
        }
        if (party.getOrder() < 0) {
            obj.remove((Object)"order");
        }
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(department_update_uri, token.getAccessToken()), obj.toJSONString());
        return response.getAsJsonResult();
    }

    public List<Party> listParty(int partId) throws WeixinException {
        String department_list_uri = this.getRequestUri("department_list_uri");
        if (partId > 0) {
            department_list_uri = department_list_uri + String.format("&id=%d", partId);
        }
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.get(String.format(department_list_uri, token.getAccessToken()));
        return JSON.parseArray((String)response.getAsJson().getString("department"), Party.class);
    }

    public JsonResult deleteParty(int partId) throws WeixinException {
        String department_delete_uri = this.getRequestUri("department_delete_uri");
        Token token = (Token)this.tokenManager.getCache();
        WeixinResponse response = this.weixinExecutor.post(String.format(department_delete_uri, token.getAccessToken(), partId));
        return response.getAsJsonResult();
    }
}

