/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy.api;

import com.foxinmy.weixin4j.model.Consts;
import com.foxinmy.weixin4j.model.WeixinAccount;
import com.foxinmy.weixin4j.qy.api.QyApi;
import com.foxinmy.weixin4j.util.Weixin4jConfigUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class OauthApi
extends QyApi {
    private final WeixinAccount account;

    public OauthApi() {
        this(Weixin4jConfigUtil.getWeixinAccount());
    }

    public OauthApi(WeixinAccount account) {
        this.account = account;
    }

    public String getUserAuthorizeURL() {
        String redirectUri = Weixin4jConfigUtil.getValue((String)"user.oauth.redirect.uri");
        return this.getUserAuthorizeURL(redirectUri, "state");
    }

    public String getUserAuthorizeURL(String redirectUri, String state) {
        String oauth_uri = this.getRequestUri("user_oauth_uri");
        try {
            return String.format(oauth_uri, this.account.getId(), URLEncoder.encode(redirectUri, Consts.UTF_8.name()), state);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public String getThirdAuthorizeURL() {
        String redirectUri = Weixin4jConfigUtil.getValue((String)"third.oauth.redirect.uri");
        return this.getThirdAuthorizeURL(redirectUri, "state");
    }

    public String getThirdAuthorizeURL(String redirectUri, String state) {
        String oauth_uri = this.getRequestUri("provider_oauth_uri");
        try {
            return String.format(oauth_uri, this.account.getId(), URLEncoder.encode(redirectUri, Consts.UTF_8.name()), state);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

