/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.qy;

import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.JsonResult;
import com.foxinmy.weixin4j.model.Button;
import com.foxinmy.weixin4j.model.MediaCounter;
import com.foxinmy.weixin4j.model.MediaDownloadResult;
import com.foxinmy.weixin4j.model.MediaItem;
import com.foxinmy.weixin4j.model.MediaRecord;
import com.foxinmy.weixin4j.model.MediaUploadResult;
import com.foxinmy.weixin4j.model.Pageable;
import com.foxinmy.weixin4j.model.WeixinAccount;
import com.foxinmy.weixin4j.qy.api.AgentApi;
import com.foxinmy.weixin4j.qy.api.BatchApi;
import com.foxinmy.weixin4j.qy.api.ChatApi;
import com.foxinmy.weixin4j.qy.api.HelperApi;
import com.foxinmy.weixin4j.qy.api.MediaApi;
import com.foxinmy.weixin4j.qy.api.MenuApi;
import com.foxinmy.weixin4j.qy.api.NotifyApi;
import com.foxinmy.weixin4j.qy.api.PartyApi;
import com.foxinmy.weixin4j.qy.api.TagApi;
import com.foxinmy.weixin4j.qy.api.UserApi;
import com.foxinmy.weixin4j.qy.message.ChatMessage;
import com.foxinmy.weixin4j.qy.message.CustomeMessage;
import com.foxinmy.weixin4j.qy.message.NotifyMessage;
import com.foxinmy.weixin4j.qy.model.AgentInfo;
import com.foxinmy.weixin4j.qy.model.AgentOverview;
import com.foxinmy.weixin4j.qy.model.AgentSetter;
import com.foxinmy.weixin4j.qy.model.BatchResult;
import com.foxinmy.weixin4j.qy.model.Callback;
import com.foxinmy.weixin4j.qy.model.ChatInfo;
import com.foxinmy.weixin4j.qy.model.ChatMute;
import com.foxinmy.weixin4j.qy.model.Contacts;
import com.foxinmy.weixin4j.qy.model.IdParameter;
import com.foxinmy.weixin4j.qy.model.Party;
import com.foxinmy.weixin4j.qy.model.Tag;
import com.foxinmy.weixin4j.qy.model.User;
import com.foxinmy.weixin4j.qy.suite.SuitePerCodeManager;
import com.foxinmy.weixin4j.qy.suite.WeixinTokenSuiteCreator;
import com.foxinmy.weixin4j.qy.token.WeixinTicketCreator;
import com.foxinmy.weixin4j.qy.token.WeixinTokenCreator;
import com.foxinmy.weixin4j.qy.type.ChatType;
import com.foxinmy.weixin4j.qy.type.InviteType;
import com.foxinmy.weixin4j.qy.type.KfType;
import com.foxinmy.weixin4j.qy.type.UserStatus;
import com.foxinmy.weixin4j.setting.Weixin4jSettings;
import com.foxinmy.weixin4j.token.TokenCreator;
import com.foxinmy.weixin4j.token.TokenManager;
import com.foxinmy.weixin4j.tuple.MpArticle;
import com.foxinmy.weixin4j.type.MediaType;
import com.foxinmy.weixin4j.type.TicketType;
import com.foxinmy.weixin4j.util.Weixin4jConfigUtil;
import java.io.InputStream;
import java.util.List;

public class WeixinProxy {
    private final MediaApi mediaApi;
    private final MenuApi menuApi;
    private final NotifyApi notifyApi;
    private final PartyApi partyApi;
    private final UserApi userApi;
    private final TagApi tagApi;
    private final HelperApi helperApi;
    private final AgentApi agentApi;
    private final BatchApi batchApi;
    private final ChatApi chatApi;
    private final TokenManager tokenManager;
    private Weixin4jSettings<WeixinAccount> settings;
    public static final String VERSION = "1.7.0";

    public WeixinProxy() {
        this((Weixin4jSettings<WeixinAccount>)new Weixin4jSettings((Object)Weixin4jConfigUtil.getWeixinAccount()));
    }

    public WeixinProxy(Weixin4jSettings<WeixinAccount> settings) {
        this(new TokenManager((TokenCreator)new WeixinTokenCreator(((WeixinAccount)settings.getAccount()).getId(), ((WeixinAccount)settings.getAccount()).getSecret()), settings.getCacheStorager0()));
        this.settings = settings;
    }

    public WeixinProxy(SuitePerCodeManager perCodeManager, TokenManager suiteTokenManager) {
        this(new TokenManager((TokenCreator)new WeixinTokenSuiteCreator(perCodeManager, suiteTokenManager), perCodeManager.getCacheStorager()));
        this.settings = new Weixin4jSettings((Object)new WeixinAccount(perCodeManager.getAuthCorpId(), null));
    }

    private WeixinProxy(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
        this.partyApi = new PartyApi(tokenManager);
        this.userApi = new UserApi(tokenManager);
        this.tagApi = new TagApi(tokenManager);
        this.helperApi = new HelperApi(tokenManager);
        this.agentApi = new AgentApi(tokenManager);
        this.batchApi = new BatchApi(tokenManager);
        this.notifyApi = new NotifyApi(tokenManager);
        this.menuApi = new MenuApi(tokenManager);
        this.mediaApi = new MediaApi(tokenManager);
        this.chatApi = new ChatApi(tokenManager);
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public WeixinAccount getWeixinAccount() {
        return (WeixinAccount)this.settings.getAccount();
    }

    public TokenManager getTicketManager(TicketType ticketType) {
        return new TokenManager((TokenCreator)new WeixinTicketCreator(this.getWeixinAccount().getId(), ticketType, this.tokenManager), this.settings.getCacheStorager0());
    }

    public IdParameter sendNotifyMessage(NotifyMessage message) throws WeixinException {
        return this.notifyApi.sendNotifyMessage(message);
    }

    public JsonResult sendCustomeMessage(CustomeMessage message) throws WeixinException {
        return this.notifyApi.sendCustomeMessage(message);
    }

    public IdParameter[] getKfList(KfType kfType) throws WeixinException {
        return this.notifyApi.getKfList(kfType);
    }

    public JsonResult createMenu(int agentid, List<Button> buttons) throws WeixinException {
        return this.menuApi.createMenu(agentid, buttons);
    }

    public List<Button> getMenu(int agentid) throws WeixinException {
        return this.menuApi.getMenu(agentid);
    }

    public JsonResult deleteMenu(int agentid) throws WeixinException {
        return this.menuApi.deleteMenu(agentid);
    }

    public String uploadImage(InputStream is, String fileName) throws WeixinException {
        return this.mediaApi.uploadImage(is, fileName);
    }

    public MediaUploadResult uploadMedia(int agentid, InputStream is, String fileName) throws WeixinException {
        return this.mediaApi.uploadMedia(agentid, is, fileName);
    }

    public MediaDownloadResult downloadMedia(int agentid, String mediaId) throws WeixinException {
        return this.mediaApi.downloadMedia(agentid, mediaId);
    }

    public String uploadMaterialArticle(int agentid, List<MpArticle> articles) throws WeixinException {
        return this.mediaApi.uploadMaterialArticle(agentid, articles);
    }

    public JsonResult deleteMaterialMedia(int agentid, String mediaId) throws WeixinException {
        return this.mediaApi.deleteMaterialMedia(agentid, mediaId);
    }

    public List<MpArticle> downloadArticle(int agentid, String mediaId) throws WeixinException {
        return this.mediaApi.downloadArticle(agentid, mediaId);
    }

    public String updateMaterialArticle(int agentid, String mediaId, List<MpArticle> articles) throws WeixinException {
        return this.mediaApi.updateMaterialArticle(agentid, mediaId, articles);
    }

    public MediaCounter countMaterialMedia(int agentid) throws WeixinException {
        return this.mediaApi.countMaterialMedia(agentid);
    }

    public MediaRecord listMaterialMedia(int agentid, MediaType mediaType, Pageable pageable) throws WeixinException {
        return this.mediaApi.listMaterialMedia(agentid, mediaType, pageable);
    }

    public List<MediaItem> listAllMaterialMedia(int agentid, MediaType mediaType) throws WeixinException {
        return this.mediaApi.listAllMaterialMedia(agentid, mediaType);
    }

    public int createParty(Party party) throws WeixinException {
        return this.partyApi.createParty(party);
    }

    public JsonResult updateParty(Party party) throws WeixinException {
        return this.partyApi.updateParty(party);
    }

    public List<Party> listParty(int partyId) throws WeixinException {
        return this.partyApi.listParty(partyId);
    }

    public JsonResult deleteParty(int partyId) throws WeixinException {
        return this.partyApi.deleteParty(partyId);
    }

    public String batchUploadParties(List<Party> parties) throws WeixinException {
        return this.mediaApi.batchUploadParties(parties);
    }

    public JsonResult createUser(User user) throws WeixinException {
        return this.userApi.createUser(user);
    }

    public JsonResult createUser(User user, InputStream avatar) throws WeixinException {
        return this.userApi.createUser(user, avatar);
    }

    public JsonResult updateUser(User user) throws WeixinException {
        return this.userApi.updateUser(user);
    }

    public JsonResult updateUser(User user, InputStream avatar) throws WeixinException {
        return this.userApi.updateUser(user, avatar);
    }

    public User getUser(String userid) throws WeixinException {
        return this.userApi.getUser(userid);
    }

    public User getUserByCode(String code) throws WeixinException {
        return this.userApi.getUserByCode(code);
    }

    public String[] getUserIdByCode(String code) throws WeixinException {
        return this.userApi.getUserIdByCode(code);
    }

    public List<User> listUser(int partyId, boolean fetchChild, UserStatus userStatus, boolean findDetail) throws WeixinException {
        return this.userApi.listUser(partyId, fetchChild, userStatus, findDetail);
    }

    public List<User> listUser(int partyId) throws WeixinException {
        return this.userApi.listUser(partyId);
    }

    public JsonResult deleteUser(String userid) throws WeixinException {
        return this.userApi.deleteUser(userid);
    }

    public JsonResult batchDeleteUser(List<String> userIds) throws WeixinException {
        return this.userApi.batchDeleteUser(userIds);
    }

    public InviteType inviteUser(String userId, String tips) throws WeixinException {
        return this.userApi.inviteUser(userId, tips);
    }

    public int createTag(Tag tag) throws WeixinException {
        return this.tagApi.createTag(tag);
    }

    public JsonResult updateTag(Tag tag) throws WeixinException {
        return this.tagApi.updateTag(tag);
    }

    public JsonResult deleteTag(int tagId) throws WeixinException {
        return this.tagApi.deleteTag(tagId);
    }

    public List<Tag> listTag() throws WeixinException {
        return this.tagApi.listTag();
    }

    public Contacts getTagUsers(int tagId) throws WeixinException {
        return this.tagApi.getTagUsers(tagId);
    }

    public IdParameter addTagUsers(int tagId, List<String> userIds, List<Integer> partyIds) throws WeixinException {
        return this.tagApi.addTagUsers(tagId, userIds, partyIds);
    }

    public IdParameter deleteTagUsers(int tagId, List<String> userIds, List<Integer> partyIds) throws WeixinException {
        return this.tagApi.deleteTagUsers(tagId, userIds, partyIds);
    }

    public List<String> getWechatServerIp() throws WeixinException {
        return this.helperApi.getWechatServerIp();
    }

    public AgentInfo getAgent(int agentid) throws WeixinException {
        return this.agentApi.getAgent(agentid);
    }

    public JsonResult setAgent(AgentSetter agentSet) throws WeixinException {
        return this.agentApi.setAgent(agentSet);
    }

    public List<AgentOverview> listAgentOverview() throws WeixinException {
        return this.agentApi.listAgentOverview();
    }

    public String batchInviteUser(IdParameter parameter, Callback callback, String tips) throws WeixinException {
        return this.batchApi.inviteUser(parameter, callback, tips);
    }

    public String batchSyncUser(String mediaId, Callback callback) throws WeixinException {
        return this.batchApi.syncUser(mediaId, callback);
    }

    public String batchReplaceUser(String mediaId, Callback callback) throws WeixinException {
        return this.batchApi.replaceUser(mediaId, callback);
    }

    public String batchUploadUsers(List<User> users) throws WeixinException {
        return this.mediaApi.batchUploadUsers(users);
    }

    public String batchReplaceParty(String mediaId, Callback callback) throws WeixinException {
        return this.batchApi.replaceParty(mediaId, callback);
    }

    public BatchResult getBatchResult(String jobId) throws WeixinException {
        return this.batchApi.getBatchResult(jobId);
    }

    public String[] userid2openid(String userid, int agentid) throws WeixinException {
        return this.userApi.userid2openid(userid, agentid);
    }

    public String openid2userid(String openid) throws WeixinException {
        return this.userApi.openid2userid(openid);
    }

    public String createChat(ChatInfo chatInfo) throws WeixinException {
        return this.chatApi.createChat(chatInfo);
    }

    public ChatInfo getChat(String chatId) throws WeixinException {
        return this.chatApi.getChat(chatId);
    }

    public JsonResult updateChat(ChatInfo chatInfo, String operator, List<String> addUsers, List<String> deleteUsers) throws WeixinException {
        return this.chatApi.updateChat(chatInfo, operator, addUsers, deleteUsers);
    }

    public JsonResult quitChat(String chatId, String operator) throws WeixinException {
        return this.chatApi.quitChat(chatId, operator);
    }

    public JsonResult clearChatNotify(String targetId, String owner, ChatType chatType) throws WeixinException {
        return this.chatApi.clearChatNotify(targetId, owner, chatType);
    }

    public List<String> setChatMute(List<ChatMute> chatMutes) throws WeixinException {
        return this.chatApi.setChatMute(chatMutes);
    }

    public JsonResult sendChatMessage(ChatMessage message) throws WeixinException {
        return this.chatApi.sendChatMessage(message);
    }
}

