/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks.db;

import com.carrotsearch.junitbenchmarks.AutocloseConsumer;
import com.carrotsearch.junitbenchmarks.Result;
import com.carrotsearch.junitbenchmarks.db.DbVersions;
import com.carrotsearch.junitbenchmarks.db.HistoryChartVisitor;
import com.carrotsearch.junitbenchmarks.db.IChartAnnotationVisitor;
import com.carrotsearch.junitbenchmarks.db.MethodChartVisitor;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class DbConsumer
extends AutocloseConsumer
implements Closeable {
    public static final int RUN_ID;
    public static final int CLASSNAME;
    public static final int NAME;
    public static final int BENCHMARK_ROUNDS;
    public static final int WARMUP_ROUNDS;
    public static final int ROUND_AVG;
    public static final int ROUND_STDDEV;
    public static final int GC_AVG;
    public static final int GC_STDDEV;
    public static final int GC_INVOCATIONS;
    public static final int GC_TIME;
    public static final int TIME_BENCHMARK;
    public static final int TIME_WARMUP;
    private Connection connection;
    private int runId = -1;
    private PreparedStatement newTest;
    private File chartsDir;
    private List<IChartAnnotationVisitor> chartVisitors;
    private String customKeyValue;

    public DbConsumer(File chartsDir, String customKeyValue) {
        this.chartsDir = chartsDir;
        this.customKeyValue = customKeyValue;
        this.chartVisitors = this.newChartVisitors();
        AutocloseConsumer.addAutoclose(this);
    }

    private List<IChartAnnotationVisitor> newChartVisitors() {
        ArrayList<IChartAnnotationVisitor> visitors = new ArrayList<IChartAnnotationVisitor>();
        visitors.add(new MethodChartVisitor());
        visitors.add(new HistoryChartVisitor());
        return visitors;
    }

    @Override
    public void accept(Result result) {
        Class<?> clazz = result.getTestClass();
        Method method = result.getTestMethod();
        for (IChartAnnotationVisitor v : this.chartVisitors) {
            v.visit(clazz, method, result);
        }
        try {
            PreparedStatement testInsertStatement = this.getTestInsertStatement();
            testInsertStatement.setString(CLASSNAME, result.getTestClassName());
            testInsertStatement.setString(NAME, result.getTestMethodName());
            testInsertStatement.setInt(BENCHMARK_ROUNDS, result.benchmarkRounds);
            testInsertStatement.setInt(WARMUP_ROUNDS, result.warmupRounds);
            testInsertStatement.setDouble(ROUND_AVG, result.roundAverage.avg);
            testInsertStatement.setDouble(ROUND_STDDEV, result.roundAverage.stddev);
            testInsertStatement.setDouble(GC_AVG, result.gcAverage.avg);
            testInsertStatement.setDouble(GC_STDDEV, result.gcAverage.stddev);
            testInsertStatement.setInt(GC_INVOCATIONS, (int)result.gcInfo.accumulatedInvocations());
            testInsertStatement.setDouble(GC_TIME, (double)result.gcInfo.accumulatedTime() / 1000.0);
            testInsertStatement.setDouble(TIME_WARMUP, (double)result.warmupTime / 1000.0);
            testInsertStatement.setDouble(TIME_BENCHMARK, (double)result.benchmarkTime / 1000.0);
            testInsertStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while saving the benchmark result to H2.", e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                if (!this.connection.isClosed()) {
                    this.doClose();
                }
                this.connection = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close DB consumer.", e);
        }
    }

    public void rollback() {
        try {
            this.connection.rollback();
            this.chartVisitors = this.newChartVisitors();
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not rollback.", e);
        }
    }

    public DbVersions getDbVersion() throws SQLException {
        Statement s = this.getConnection().createStatement();
        ResultSet rs = s.executeQuery("SHOW TABLES");
        HashSet<String> tables = new HashSet<String>();
        while (rs.next()) {
            tables.add(rs.getString(1));
        }
        if (!tables.contains("DBVERSION")) {
            if (tables.contains("RUNS")) {
                return DbVersions.VERSION_1;
            }
            return DbVersions.UNINITIALIZED;
        }
        rs = s.executeQuery("SELECT VERSION FROM DBVERSION");
        if (!rs.next()) {
            throw new RuntimeException("Missing version row in DBVERSION table.");
        }
        DbVersions version = DbVersions.fromInt(rs.getInt(1));
        if (rs.next()) {
            throw new RuntimeException("More than one row in DBVERSION table.");
        }
        return version;
    }

    protected static String getResource(Class<?> c, String resourceName) {
        try {
            int cnt;
            InputStream is = c.getResourceAsStream(resourceName);
            if (is == null) {
                throw new IOException();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((cnt = is.read(buffer)) > 0) {
                baos.write(buffer, 0, cnt);
            }
            is.close();
            baos.close();
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Required resource missing: " + resourceName);
        }
    }

    public static String getDefaultCustomKey() {
        return System.getProperty("jub.customkey");
    }

    public static File getDefaultChartsDir() {
        File file = new File(System.getProperty("jub.charts.dir", "."));
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    private int getRunID(String customKeyValue) throws SQLException {
        PreparedStatement s = this.getConnection().prepareStatement(this.getNewRunSql(), 1);
        s.setString(1, System.getProperty("java.runtime.version", "?"));
        s.setString(2, System.getProperty("os.arch", "?"));
        s.setString(3, customKeyValue);
        s.executeUpdate();
        ResultSet rs = s.getGeneratedKeys();
        if (!rs.next()) {
            throw new SQLException("No autogenerated keys?");
        }
        int key = rs.getInt(1);
        if (rs.next()) {
            throw new SQLException("More than one autogenerated key?");
        }
        rs.close();
        s.close();
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() throws Exception {
        try {
            for (IChartAnnotationVisitor v : this.chartVisitors) {
                v.generate(this);
            }
        }
        finally {
            if (!this.connection.isClosed()) {
                this.connection.commit();
                this.connection.close();
            }
        }
    }

    protected void checkSchema() throws SQLException {
        DbVersions dbVersion = this.getDbVersion();
        Statement s = this.connection.createStatement();
        switch (dbVersion) {
            case UNINITIALIZED: {
                s.execute(this.getCreateRunsSql());
                s.execute(this.getCreateTestsSql());
            }
            case VERSION_1: {
                s.execute(this.getCreateDbVersionSql());
                s.execute(this.getAddCustomKeySql());
                this.updateDbVersion(DbVersions.VERSION_2);
            }
            case VERSION_2: {
                break;
            }
            default: {
                throw new RuntimeException("Unexpected database version: " + (Object)((Object)dbVersion));
            }
        }
        this.connection.commit();
    }

    private void updateDbVersion(DbVersions newVersion) throws SQLException {
        Statement s = this.getConnection().createStatement();
        s.executeUpdate("DELETE FROM DBVERSION");
        s.executeUpdate("INSERT INTO DBVERSION (VERSION) VALUES (" + newVersion.version + ")");
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        return this.connection;
    }

    public String getCustomKeyValue() {
        return this.customKeyValue;
    }

    public File getChartsDir() {
        return this.chartsDir;
    }

    public String getHistoryHtmlTemplate() {
        return DbConsumer.getResource(DbConsumer.class, "HistoryChartGenerator.html");
    }

    public String getMethodHtmlTemplate() {
        return DbConsumer.getResource(DbConsumer.class, "MethodChartGenerator.html");
    }

    public int getRunId() throws SQLException {
        if (this.runId == -1) {
            this.runId = this.getRunID(this.customKeyValue);
        }
        return this.runId;
    }

    protected PreparedStatement getTestInsertStatement() throws SQLException {
        if (this.newTest == null) {
            this.newTest = this.getConnection().prepareStatement(this.getTestInsertSql());
            this.newTest.setInt(RUN_ID, this.getRunId());
        }
        return this.newTest;
    }

    public abstract String getMethodChartPropertiesQuery();

    public abstract String getMethodChartResultsQuery();

    protected abstract String getCreateTestsSql();

    protected abstract String getTestInsertSql();

    protected abstract String getCreateRunsSql();

    protected abstract String getNewRunSql();

    protected abstract String getCreateDbVersionSql();

    protected abstract String getAddCustomKeySql();

    protected abstract Connection createConnection() throws SQLException;

    static {
        int column = 1;
        RUN_ID = column++;
        CLASSNAME = column++;
        NAME = column++;
        BENCHMARK_ROUNDS = column++;
        WARMUP_ROUNDS = column++;
        ROUND_AVG = column++;
        ROUND_STDDEV = column++;
        GC_AVG = column++;
        GC_STDDEV = column++;
        GC_INVOCATIONS = column++;
        GC_TIME = column++;
        TIME_BENCHMARK = column++;
        TIME_WARMUP = column++;
    }
}

