/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.service;

import com.baomidou.kisso.SSOCache;
import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.SSOPlugin;
import com.baomidou.kisso.SSOStatistic;
import com.baomidou.kisso.Token;
import com.baomidou.kisso.common.Browser;
import com.baomidou.kisso.common.CookieHelper;
import com.baomidou.kisso.common.IpHelper;
import com.baomidou.kisso.common.encrypt.SSOEncrypt;
import com.baomidou.kisso.common.util.RandomUtil;
import com.baomidou.kisso.exception.KissoException;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KissoServiceSupport {
    protected final Logger logger = Logger.getLogger("KissoServiceSupport");
    protected SSOConfig config;

    public SSOConfig getConfig() {
        return this.config;
    }

    public void setConfig(SSOConfig config) {
        this.config = config;
    }

    public <T extends Token> T attrToken(HttpServletRequest request) {
        return (T)((Token)request.getAttribute("SSOTokenAttr"));
    }

    protected Token getToken(HttpServletRequest request, SSOEncrypt encrypt, SSOCache cache) {
        if (encrypt == null) {
            throw new KissoException(" Encrypt not for null.");
        }
        Token tk = this.checkIp(request, this.cacheToken(request, encrypt, cache));
        List<SSOPlugin> pluginList = this.config.getPluginList();
        if (pluginList != null) {
            for (SSOPlugin plugin : pluginList) {
                boolean valid = plugin.validateToken(tk);
                if (valid) continue;
                return null;
            }
        }
        return tk;
    }

    private Token cacheToken(HttpServletRequest request, SSOEncrypt encrypt, SSOCache cache) {
        if (cache != null) {
            Token cookieToken = this.getTokenFromCookie(request);
            if (cookieToken == null) {
                return null;
            }
            Token cacheToken = cache.get(cookieToken.toCacheKey(), this.config.getCacheExpires());
            if (cacheToken == null) {
                this.logger.fine("cacheToken token is null.");
                return null;
            }
            if (cacheToken.getFlag() != 1) {
                if (cookieToken.getTime() == cacheToken.getTime()) {
                    return cacheToken;
                }
                this.logger.severe("Login time is not consistent or kicked out.");
                request.setAttribute("SSOKickFlag", (Object)"SSOKickUser");
                return null;
            }
        }
        return this.getToken(request, encrypt, this.config.getCookieName());
    }

    protected Token getToken(HttpServletRequest request, SSOEncrypt encrypt, String cookieName) {
        String jsonToken = this.getJsonToken(request, encrypt, cookieName);
        if (jsonToken == null || "".equals(jsonToken)) {
            this.logger.fine("jsonToken is null.");
            return null;
        }
        return this.config.getToken().parseToken(jsonToken);
    }

    protected String getJsonToken(HttpServletRequest request, SSOEncrypt encrypt, String cookieName) {
        Cookie uid = CookieHelper.findCookieByName(request, cookieName);
        if (uid != null) {
            String jsonToken = uid.getValue();
            String[] tokenAttr = new String[2];
            try {
                jsonToken = encrypt.decrypt(jsonToken, this.config.getSecretkey());
                tokenAttr = jsonToken.split("#");
            }
            catch (Exception e) {
                this.logger.severe("jsonToken decrypt error, may be fake login. IP = " + IpHelper.getIpAddr(request));
            }
            if (this.config.getCookieBrowser()) {
                if (Browser.isLegalUserAgent(request, tokenAttr[0], tokenAttr[1])) {
                    return tokenAttr[0];
                }
                this.logger.severe("SSOHelper getToken, find Browser is illegal.");
            } else {
                return tokenAttr[0];
            }
        }
        return null;
    }

    protected Token checkIp(HttpServletRequest request, Token token) {
        if (this.config.getCookieCheckip()) {
            String ip = IpHelper.getIpAddr(request);
            if (token != null && ip != null && !ip.equals(token.getIp())) {
                this.logger.info(String.format("ip inconsistent! return token null, token userIp:%s, reqIp:%s", token.getIp(), ip));
                return null;
            }
        }
        return token;
    }

    public Token getTokenFromCookie(HttpServletRequest request) {
        Object tk = this.attrToken(request);
        if (tk == null) {
            tk = this.getToken(request, this.config.getEncrypt(), this.config.getCookieName());
        }
        return tk;
    }

    private Cookie generateCookie(HttpServletRequest request, Token token, SSOEncrypt encrypt) {
        try {
            Cookie cookie = new Cookie(this.config.getCookieName(), this.encryptCookie(request, token, encrypt));
            cookie.setPath(this.config.getCookiePath());
            cookie.setSecure(this.config.getCookieSecure());
            String domain = this.config.getCookieDomain();
            cookie.setDomain(domain);
            if ("".equals(domain) || domain.contains("localhost")) {
                this.logger.warning("if you can't login, please enter normal domain. instead:" + domain);
            }
            int maxAge = this.config.getCookieMaxage();
            Integer attrMaxAge = (Integer)request.getAttribute("sso_cookie_maxage");
            if (attrMaxAge != null) {
                maxAge = attrMaxAge;
            }
            if (maxAge >= 0) {
                cookie.setMaxAge(maxAge);
            }
            return cookie;
        }
        catch (Exception e) {
            this.logger.severe("generateCookie is exception!" + e.toString());
            return null;
        }
    }

    protected String encryptCookie(HttpServletRequest request, Token token, SSOEncrypt encrypt) throws Exception {
        if (token == null) {
            throw new KissoException(" Token not for null.");
        }
        String jt = token.jsonToken();
        StringBuffer sf = new StringBuffer();
        sf.append(jt);
        sf.append("#");
        if (this.config.getCookieBrowser()) {
            sf.append(Browser.getUserAgent(request, jt));
        } else {
            sf.append(RandomUtil.getCharacterAndNumber(8));
        }
        return encrypt.encrypt(sf.toString(), this.config.getSecretkey());
    }

    protected void setSSOCookie(HttpServletRequest request, HttpServletResponse response, Token token, SSOEncrypt encrypt) {
        if (encrypt == null) {
            throw new KissoException(" Encrypt not for null.");
        }
        try {
            List<SSOPlugin> pluginList;
            boolean rlt;
            SSOStatistic statistic;
            boolean rlt2;
            Cookie ck = this.generateCookie(request, token, encrypt);
            SSOCache cache = this.config.getCache();
            if (cache != null && !(rlt2 = cache.set(token.toCacheKey(), token, this.config.getCacheExpires()))) {
                token.setFlag(1);
            }
            if ((statistic = this.config.getStatistic()) != null && !(rlt = statistic.increase(request))) {
                statistic.increase(request);
            }
            if ((pluginList = this.config.getPluginList()) != null) {
                for (SSOPlugin plugin : pluginList) {
                    boolean login = plugin.login(request, response);
                    if (login) continue;
                    plugin.login(request, response);
                }
            }
            if (this.config.getCookieHttponly()) {
                CookieHelper.addHttpOnlyCookie(response, ck);
            } else {
                response.addCookie(ck);
            }
        }
        catch (Exception e) {
            this.logger.severe("set HTTPOnly cookie createAUID is exception! " + e.toString());
        }
    }

    protected boolean logout(HttpServletRequest request, HttpServletResponse response, SSOCache cache) {
        List<SSOPlugin> pluginList;
        SSOStatistic statistic;
        boolean rlt;
        Token tk;
        if (cache != null && !"SSOKickUser".equals(request.getAttribute("SSOKickFlag")) && (tk = this.getTokenFromCookie(request)) != null && !(rlt = cache.delete(tk.toCacheKey()))) {
            cache.delete(tk.toCacheKey());
        }
        if ((statistic = this.config.getStatistic()) != null && !(rlt = statistic.decrease(request))) {
            statistic.decrease(request);
        }
        if ((pluginList = this.config.getPluginList()) != null) {
            for (SSOPlugin plugin : pluginList) {
                boolean logout = plugin.logout(request, response);
                if (logout) continue;
                plugin.logout(request, response);
            }
        }
        return CookieHelper.clearCookieByName(request, response, this.config.getCookieName(), this.config.getCookieDomain(), this.config.getCookiePath());
    }
}

