/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.kisso.AuthToken;
import com.baomidou.kisso.SSOCache;
import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.SSOStatistic;
import com.baomidou.kisso.Token;
import com.baomidou.kisso.common.CookieHelper;
import com.baomidou.kisso.common.util.HttpUtil;
import com.baomidou.kisso.common.util.RandomUtil;
import com.baomidou.kisso.service.KissoService;
import com.baomidou.kisso.service.KissoServiceSupport;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractKissoService
extends KissoServiceSupport
implements KissoService {
    public Token getToken(HttpServletRequest request) {
        return this.getToken(request, this.config.getEncrypt(), this.config.getCache());
    }

    public String getLoginCount(HttpServletRequest request) {
        SSOStatistic statistic = this.config.getStatistic();
        if (statistic != null) {
            return statistic.count(request);
        }
        this.logger.warning("please instanceof SSOStatistic.");
        return null;
    }

    public boolean kickLogin(Object userId) {
        SSOCache cache = this.config.getCache();
        if (cache != null) {
            return cache.delete(SSOConfig.toCacheKey(userId));
        }
        this.logger.info(" kickLogin! please implements SSOCache class.");
        return false;
    }

    public void setSSOCookie(HttpServletRequest request, HttpServletResponse response, Token token) {
        this.setSSOCookie(request, response, token, this.config.getEncrypt());
    }

    public void authSSOCookie(HttpServletRequest request, HttpServletResponse response, Token token) {
        CookieHelper.authJSESSIONID(request, RandomUtil.getCharacterAndNumber(8));
        this.setSSOCookie(request, response, token);
    }

    public boolean clearLogin(HttpServletRequest request, HttpServletResponse response) {
        return this.logout(request, response, this.config.getCache());
    }

    public void clearRedirectLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.clearLogin(request, response);
        String loginUrl = this.config.getLoginUrl();
        if ("".equals(loginUrl)) {
            response.getWriter().write("sso.properties Must include: sso.login.url");
        } else {
            String retUrl = HttpUtil.getQueryString(request, this.config.getEncoding());
            this.logger.fine("loginAgain redirect pageUrl.." + retUrl);
            response.sendRedirect(HttpUtil.encodeRetURL(loginUrl, this.config.getParamReturl(), retUrl));
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logout(request, response, this.config.getCache());
        String logoutUrl = this.config.getLogoutUrl();
        if ("".equals(logoutUrl)) {
            response.getWriter().write("sso.properties Must include: sso.logout.url");
        } else {
            response.sendRedirect(logoutUrl);
        }
    }

    public AuthToken askCiphertext(HttpServletRequest request, HttpServletResponse response, String privateKey) {
        AuthToken at = new AuthToken(request, privateKey);
        this.setAuthCookie(request, response, at);
        return at;
    }

    public AuthToken replyCiphertext(HttpServletRequest request, String askData) {
        AuthToken at;
        String str = null;
        try {
            str = this.config.getEncrypt().decrypt(askData, this.config.getAuthCookieSecretkey());
        }
        catch (Exception e) {
            this.logger.severe("replyCiphertext AES decrypt error.\n" + e.toString());
        }
        if (str != null && this.checkIp(request, at = (AuthToken)JSON.parseObject((String)str, AuthToken.class)) != null) {
            return at;
        }
        return null;
    }

    public AuthToken ok(HttpServletRequest request, HttpServletResponse response, String replyTxt, String atPk, String ssoPrk) {
        AuthToken token = this.getAuthCookie(request, atPk);
        if (token != null) {
            AuthToken at;
            String rt = null;
            try {
                rt = this.config.getEncrypt().decrypt(replyTxt, this.config.getAuthCookieSecretkey());
            }
            catch (Exception e) {
                this.logger.severe("kisso AES decrypt error.");
                e.printStackTrace();
            }
            if (rt != null && (at = (AuthToken)JSON.parseObject((String)rt, AuthToken.class)) != null && at.getUuid().equals(token.getUuid()) && at.verify(ssoPrk) != null) {
                CookieHelper.clearCookieByName(request, response, this.config.getAuthCookieName(), this.config.getCookieDomain(), this.config.getCookiePath());
                return at;
            }
        }
        return null;
    }

    private void setAuthCookie(HttpServletRequest request, HttpServletResponse response, AuthToken authToken) {
        try {
            CookieHelper.addCookie(response, this.config.getCookieDomain(), this.config.getCookiePath(), this.config.getAuthCookieName(), this.encryptCookie(request, authToken, this.config.getEncrypt()), this.config.getAuthCookieMaxage(), true, this.config.getCookieSecure());
        }
        catch (Exception e) {
            this.logger.severe("AuthToken encryptCookie error.\n" + e.toString());
        }
    }

    private AuthToken getAuthCookie(HttpServletRequest request, String publicKey) {
        String jsonToken = this.getJsonToken(request, this.config.getEncrypt(), this.config.getAuthCookieName());
        if (jsonToken == null || "".equals(jsonToken)) {
            this.logger.info("jsonToken is null.");
            return null;
        }
        AuthToken at = (AuthToken)JSON.parseObject((String)jsonToken, AuthToken.class);
        if (this.checkIp(request, at) == null) {
            return null;
        }
        return at;
    }
}

