/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.parser.api;

import com.baomidou.kisso.common.parser.api.EncryptMsg;
import com.baomidou.kisso.exception.AESException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLParser {
    public static EncryptMsg extract(String xmltext) throws AESException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader sr = new StringReader(xmltext);
            InputSource is = new InputSource(sr);
            Document document = db.parse(is);
            Element root = document.getDocumentElement();
            NodeList nodelist1 = root.getElementsByTagName("Encrypt");
            NodeList nodelist2 = root.getElementsByTagName("MsgSignature");
            NodeList nodelist3 = root.getElementsByTagName("TimeStamp");
            NodeList nodelist4 = root.getElementsByTagName("Nonce");
            String encrypt = nodelist1.item(0).getTextContent();
            String signature = nodelist2.item(0).getTextContent();
            String timestamp = nodelist3.item(0).getTextContent();
            String nonce = nodelist4.item(0).getTextContent();
            return new EncryptMsg(encrypt, signature, timestamp, nonce);
        }
        catch (Exception e) {
            throw new AESException(-10002, (Throwable)e);
        }
    }

    public static String generate(String encrypt, String signature, String timeStamp, String nonce) {
        StringBuffer format = new StringBuffer();
        format.append("<xml>\n");
        format.append("<Encrypt><![CDATA[%1$s]]></Encrypt>\n");
        format.append("<MsgSignature><![CDATA[%2$s]]></MsgSignature>\n");
        format.append("<TimeStamp>%3$s</TimeStamp>\n");
        format.append("<Nonce><![CDATA[%4$s]]></Nonce>\n");
        format.append("</xml>");
        return String.format(format.toString(), encrypt, signature, timeStamp, nonce);
    }
}

