/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Algorithm {
    DES("DES", "DES encrypt"),
    AES("AES", "AES encrypt"),
    BLOWFISH("BLOWFISH", "Blowfish encrypt"),
    RC2("RC2", "RC2 encrypt"),
    RC4("RC4", "RC4 encrypt");

    private final String key;
    private final String desc;

    private Algorithm(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    public String getKey() {
        return this.key;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Algorithm convert(String encryptAlgorithm) {
        Algorithm algorithm = RC4;
        if (null != encryptAlgorithm) {
            Algorithm[] algs;
            for (Algorithm alg : algs = Algorithm.values()) {
                if (!alg.getKey().equals(encryptAlgorithm)) continue;
                algorithm = alg;
                break;
            }
        }
        return algorithm;
    }
}

