/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.captcha.background;

import com.baomidou.kisso.common.captcha.background.BackgroundFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;

public class LineNoiseBackgroundFactory
implements BackgroundFactory {
    private static final Random rand = new Random();
    private int noises = 20;

    public LineNoiseBackgroundFactory() {
    }

    public LineNoiseBackgroundFactory(int noises) {
        this.noises = noises;
    }

    public void fillBackground(BufferedImage image) {
        Graphics graphics = image.getGraphics();
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, imgWidth, imgHeight);
        for (int i = 0; i < this.getNoises(); ++i) {
            int rInt = rand.nextInt(255);
            int gInt = rand.nextInt(255);
            int bInt = rand.nextInt(255);
            graphics.setColor(new Color(rInt, gInt, bInt));
            int xInt = rand.nextInt(imgWidth - 3);
            int yInt = rand.nextInt(imgHeight - 2);
            int sAngleInt = rand.nextInt(60);
            int eAngleInt = rand.nextInt(360);
            int wInt = rand.nextInt(6);
            int hInt = rand.nextInt(6);
            graphics.fillArc(xInt, yInt, wInt, hInt, sAngleInt, eAngleInt);
            if (i % 20 != 0) continue;
            int xInt2 = rand.nextInt(imgWidth);
            int yInt2 = rand.nextInt(imgHeight);
            graphics.drawLine(xInt, yInt, xInt2, yInt2);
        }
    }

    public int getNoises() {
        return this.noises;
    }

    public void setNoises(int noises) {
        this.noises = noises;
    }
}

