/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.captcha;

import com.baomidou.kisso.common.captcha.ICaptcha;
import com.baomidou.kisso.common.captcha.ICaptchaStore;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractCaptcha
implements ICaptcha {
    private ICaptchaStore captchaStore;
    private boolean ignoreCase = true;

    protected AbstractCaptcha() {
    }

    public AbstractCaptcha(ICaptchaStore captchaStore) {
        this.captchaStore = captchaStore;
    }

    public abstract String writeImage(HttpServletRequest var1, OutputStream var2);

    public void generate(HttpServletRequest request, OutputStream out, String ticket) {
        String captcha = this.writeImage(request, out);
        if (captcha != null) {
            this.captchaStore.put(ticket, captcha);
        }
    }

    public boolean verification(HttpServletRequest request, String ticket, String captcha) {
        String tc = this.captchaStore.get(ticket);
        if (tc != null) {
            if (this.ignoreCase) {
                return tc.equalsIgnoreCase(captcha);
            }
            return tc.equals(captcha);
        }
        return false;
    }

    public ICaptchaStore getCaptchaStore() {
        return this.captchaStore;
    }

    public void setCaptchaStore(ICaptchaStore captchaStore) {
        this.captchaStore = captchaStore;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }
}

