/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso;

import com.baomidou.kisso.SSOCache;
import com.baomidou.kisso.SSOPlugin;
import com.baomidou.kisso.SSOStatistic;
import com.baomidou.kisso.Token;
import com.baomidou.kisso.common.SSOProperties;
import com.baomidou.kisso.common.SSOReflectHelper;
import com.baomidou.kisso.common.encrypt.SSOEncrypt;
import com.baomidou.kisso.common.parser.SSOParser;
import com.baomidou.kisso.exception.KissoException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOConfig {
    private static final Logger logger = Logger.getLogger("SSOConfig");
    private static final String SSO_ENCODING = "UTF-8";
    private String runMode = "online_mode";
    private String role = "";
    private String encoding = "UTF-8";
    private String secretkey = "p00Tm071X992t3Eg05";
    private String cookieName = "uid";
    private String cookieDomain = "";
    private String cookiePath = "/";
    private boolean cookieSecure = false;
    private boolean cookieHttponly = true;
    private int cookieMaxage = -1;
    private boolean cookieBrowser = true;
    private boolean cookieCheckip = false;
    private String loginUrl = "";
    private String logoutUrl = "";
    private String paramReturl = "ReturnURL";
    private String authCookieSecretkey = "Lg8V51188n0709i5l81";
    private String authCookieName = "pid";
    private int authCookieMaxage = 180;
    private String tokenClass = null;
    private int cacheExpires = -1;
    private String encryptAlgorithm = null;
    private boolean permissionUri = false;
    private static List<SSOPlugin> SSO_PLUGIN_LIST = null;
    public static final String SSO_TOKEN_ATTR = "SSOTokenAttr";
    public static final String SSO_KICK_FLAG = "SSOKickFlag";
    public static final String SSO_KICK_USER = "SSOKickUser";
    public static final String SSO_COOKIE_MAXAGE = "sso_cookie_maxage";
    public static final Charset CHARSET_ENCODING = Charset.forName(SSOConfig.getSSOEncoding());
    public static final String CUT_SYMBOL = "#";
    private static final String SSO_RUN_MODE = "sso.run.mode";
    private SSOProperties properties = null;
    private static SSOConfig SSO_CONFIG = null;

    public SSOConfig() {
    }

    public SSOConfig(SSOProperties properties) {
        this.properties = properties;
    }

    public static SSOConfig getInstance() {
        if (SSO_CONFIG == null) {
            SSO_CONFIG = new SSOConfig();
        }
        return SSO_CONFIG;
    }

    public static synchronized void setInstance(SSOConfig ssoConfig) {
        if (ssoConfig == null) {
            throw new KissoException(" setInstance error, ssoConfig is null.");
        }
        SSO_CONFIG = ssoConfig;
        logger.config("loading kisso config.");
        logger.info("kisso init success.");
    }

    public synchronized void initProperties(Properties props) {
        if (props == null) {
            throw new KissoException(" cannot load kisso config. ");
        }
        SSOConfig.setInstance(new SSOConfig(new SSOProperties(props, SSO_RUN_MODE, this.getRunMode())));
    }

    public static SSOProperties getSSOProperties() {
        return SSO_CONFIG.getProperties();
    }

    public static String getSSOEncoding() {
        if (SSO_CONFIG == null) {
            return SSO_ENCODING;
        }
        return SSOConfig.getInstance().getEncoding();
    }

    public SSOProperties getProperties() {
        return this.properties;
    }

    public void setProperties(SSOProperties properties) {
        this.properties = properties;
    }

    public String getRunMode() {
        if (this.properties == null) {
            return this.runMode;
        }
        return this.properties.get(SSO_RUN_MODE, this.runMode);
    }

    public void setRunMode(String runMode) {
        this.runMode = runMode;
    }

    public String getRole() {
        if (this.properties == null) {
            return this.role;
        }
        return this.properties.get("sso.role", this.role);
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getEncoding() {
        if (this.properties == null) {
            return this.encoding;
        }
        return this.properties.get("sso.encoding", this.encoding);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getSecretkey() {
        if (this.properties == null) {
            return this.secretkey;
        }
        return this.properties.get("sso.secretkey", this.secretkey);
    }

    public void setSecretkey(String secretkey) {
        this.secretkey = secretkey;
    }

    public String getCookieName() {
        if (this.properties == null) {
            return this.cookieName;
        }
        return this.properties.get("sso.cookie.name", this.cookieName);
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getCookieDomain() {
        if (this.properties == null) {
            return this.cookieDomain;
        }
        return this.properties.get("sso.cookie.domain", this.cookieDomain);
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public String getCookiePath() {
        if (this.properties == null) {
            return this.cookiePath;
        }
        return this.properties.get("sso.cookie.path", this.cookiePath);
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public boolean getCookieSecure() {
        if (this.properties == null) {
            return this.cookieSecure;
        }
        return this.properties.getBoolean("sso.cookie.secure", this.cookieSecure);
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public boolean getCookieHttponly() {
        if (this.properties == null) {
            return this.cookieHttponly;
        }
        return this.properties.getBoolean("sso.cookie.httponly", this.cookieHttponly);
    }

    public void setCookieHttponly(boolean cookieHttponly) {
        this.cookieHttponly = cookieHttponly;
    }

    public int getCookieMaxage() {
        if (this.properties == null) {
            return this.cookieMaxage;
        }
        return this.properties.getInt("sso.cookie.maxage", this.cookieMaxage);
    }

    public void setCookieMaxage(int cookieMaxage) {
        this.cookieMaxage = cookieMaxage;
    }

    public boolean getCookieBrowser() {
        if (this.properties == null) {
            return this.cookieBrowser;
        }
        return this.properties.getBoolean("sso.cookie.browser", this.cookieBrowser);
    }

    public void setCookieBrowser(boolean cookieBrowser) {
        this.cookieBrowser = cookieBrowser;
    }

    public boolean getCookieCheckip() {
        if (this.properties == null) {
            return this.cookieCheckip;
        }
        return this.properties.getBoolean("sso.cookie.checkip", this.cookieCheckip);
    }

    public void setCookieCheckip(boolean cookieCheckip) {
        this.cookieCheckip = cookieCheckip;
    }

    public String getLoginUrl() {
        if (this.properties == null) {
            return this.loginUrl;
        }
        return this.properties.get("sso.login.url", this.loginUrl);
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getLogoutUrl() {
        if (this.properties == null) {
            return this.logoutUrl;
        }
        return this.properties.get("sso.logout.url", this.logoutUrl);
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public String getParamReturl() {
        if (this.properties == null) {
            return this.paramReturl;
        }
        return this.properties.get("sso.param.returl", this.paramReturl);
    }

    public void setParamReturl(String paramReturl) {
        this.paramReturl = paramReturl;
    }

    public String getAuthCookieSecretkey() {
        if (this.properties == null) {
            return this.authCookieSecretkey;
        }
        return this.properties.get("sso.authcookie.secretkey", this.authCookieSecretkey);
    }

    public void setAuthCookieSecretkey(String authCookieSecretkey) {
        this.authCookieSecretkey = authCookieSecretkey;
    }

    public String getAuthCookieName() {
        if (this.properties == null) {
            return this.authCookieName;
        }
        return this.properties.get("sso.authcookie.name", this.authCookieName);
    }

    public void setAuthCookieName(String authCookieName) {
        this.authCookieName = authCookieName;
    }

    public int getAuthCookieMaxage() {
        if (this.properties == null) {
            return this.authCookieMaxage;
        }
        return this.properties.getInt("sso.authcookie.maxage", this.authCookieMaxage);
    }

    public void setAuthCookieMaxage(int authCookieMaxage) {
        this.authCookieMaxage = authCookieMaxage;
    }

    public Token getToken() {
        if (this.properties == null) {
            return SSOReflectHelper.getConfigToken(this.tokenClass);
        }
        return SSOReflectHelper.getConfigToken(this.properties.get("sso.token.class", ""));
    }

    public void setTokenClass(String tokenClass) {
        this.tokenClass = tokenClass;
    }

    public SSOParser getParser() {
        if (this.properties == null) {
            return SSOReflectHelper.getConfigParser(null);
        }
        return SSOReflectHelper.getConfigParser(this.properties.get("sso.parser.class", ""));
    }

    public void setParser(SSOParser parser) {
        if (parser != null) {
            SSOReflectHelper.setConfigParser(parser);
        }
    }

    public SSOEncrypt getEncrypt() {
        if (this.properties == null) {
            return SSOReflectHelper.getConfigEncrypt(null, this.getEncryptAlgorithm());
        }
        return SSOReflectHelper.getConfigEncrypt(this.properties.get("sso.encrypt.class", ""), this.getEncryptAlgorithm());
    }

    public void setEncrypt(SSOEncrypt encrypt) {
        if (encrypt != null) {
            SSOReflectHelper.setConfigEncrypt(encrypt);
        }
    }

    public SSOCache getCache() {
        if (this.properties == null) {
            return SSOReflectHelper.getConfigCache(null);
        }
        return SSOReflectHelper.getConfigCache(this.properties.get("sso.cache.class", ""));
    }

    public void setCache(SSOCache cache) {
        if (cache != null) {
            SSOReflectHelper.setConfigCache(cache);
        }
    }

    public int getCacheExpires() {
        if (this.properties == null) {
            return this.cacheExpires;
        }
        return this.properties.getInt("sso.cache.expires", this.cacheExpires);
    }

    public void setCacheExpires(int cacheExpires) {
        this.cacheExpires = cacheExpires;
    }

    public SSOStatistic getStatistic() {
        if (this.properties == null) {
            return SSOReflectHelper.getConfigStatistic(null);
        }
        return SSOReflectHelper.getConfigStatistic(this.properties.get("sso.statistic.class", ""));
    }

    public void setStatistic(SSOStatistic statistic) {
        if (statistic != null) {
            SSOReflectHelper.setConfigStatistic(statistic);
        }
    }

    public String getEncryptAlgorithm() {
        if (this.properties == null) {
            return this.encryptAlgorithm;
        }
        return this.properties.get("sso.encrypt.algorithm", this.encryptAlgorithm);
    }

    public void setEncryptAlgorithm(String encryptAlgorithm) {
        this.encryptAlgorithm = encryptAlgorithm;
    }

    public boolean isPermissionUri() {
        if (this.properties == null) {
            return this.permissionUri;
        }
        return this.properties.getBoolean("sso.permission.uri", this.permissionUri);
    }

    public void setPermissionUri(boolean permissionUri) {
        this.permissionUri = permissionUri;
    }

    public List<SSOPlugin> getPluginList() {
        return SSO_PLUGIN_LIST;
    }

    public void setPluginList(List<SSOPlugin> pluginList) {
        SSO_PLUGIN_LIST = pluginList;
    }

    public static String toCacheKey(Object userId) {
        StringBuffer ck = new StringBuffer();
        ck.append("ssoTokenKey_");
        ck.append(userId);
        return ck.toString();
    }
}

