/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.packets.client;

import com.alibaba.otter.canal.parse.driver.mysql.packets.PacketWithHeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.utils.ByteHelper;
import com.alibaba.otter.canal.parse.driver.mysql.utils.MySQLPasswordEncrypter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang.StringUtils;

public class ClientAuthenticationPacket
extends PacketWithHeaderPacket {
    private String username;
    private String password;
    private byte charsetNumber;
    private String databaseName;
    private int serverCapabilities;
    private byte[] scrumbleBuff;

    @Override
    public void fromBytes(byte[] data) {
    }

    @Override
    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteHelper.writeUnsignedIntLittleEndian(41477L, out);
        ByteHelper.writeUnsignedIntLittleEndian(0x1000000L, out);
        out.write(this.charsetNumber);
        out.write(new byte[23]);
        ByteHelper.writeNullTerminatedString(this.getUsername(), out);
        if (StringUtils.isEmpty((String)this.getPassword())) {
            out.write(0);
        } else {
            try {
                byte[] encryptedPassword = MySQLPasswordEncrypter.scramble411(this.getPassword().getBytes(), this.scrumbleBuff);
                ByteHelper.writeBinaryCodedLengthBytes(encryptedPassword, out);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("can't encrypt password that will be sent to MySQL server.", e);
            }
        }
        if (this.getDatabaseName() != null) {
            ByteHelper.writeNullTerminatedString(this.getDatabaseName(), out);
        }
        return out.toByteArray();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCharsetNumber(byte charsetNumber) {
        this.charsetNumber = charsetNumber;
    }

    public byte getCharsetNumber() {
        return this.charsetNumber;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setServerCapabilities(int serverCapabilities) {
        this.serverCapabilities = serverCapabilities;
    }

    public int getServerCapabilities() {
        return this.serverCapabilities;
    }

    public void setScrumbleBuff(byte[] scrumbleBuff) {
        this.scrumbleBuff = scrumbleBuff;
    }

    public byte[] getScrumbleBuff() {
        return this.scrumbleBuff;
    }
}

