/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql;

import com.alibaba.otter.canal.parse.driver.mysql.MysqlConnector;
import com.alibaba.otter.canal.parse.driver.mysql.packets.client.QueryCommandPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ErrorPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.OKPacket;
import com.alibaba.otter.canal.parse.driver.mysql.utils.PacketManager;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlUpdateExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MysqlUpdateExecutor.class);
    private SocketChannel channel;

    public MysqlUpdateExecutor(MysqlConnector connector) {
        if (!connector.isConnected()) {
            throw new RuntimeException("should execute connector.connect() first");
        }
        this.channel = connector.getChannel();
    }

    public MysqlUpdateExecutor(SocketChannel ch) {
        this.channel = ch;
    }

    public OKPacket update(String updateString) throws IOException {
        QueryCommandPacket cmd = new QueryCommandPacket();
        cmd.setQueryString(updateString);
        byte[] bodyBytes = cmd.toBytes();
        PacketManager.write(this.channel, bodyBytes);
        logger.debug("read update result...");
        byte[] body = PacketManager.readBytes(this.channel, PacketManager.readHeader(this.channel, 4).getPacketBodyLength());
        if (body[0] < 0) {
            ErrorPacket packet = new ErrorPacket();
            packet.fromBytes(body);
            throw new IOException(packet + "\n with command: " + updateString);
        }
        OKPacket packet = new OKPacket();
        packet.fromBytes(body);
        return packet;
    }
}

